/*
 * Decompiled with CFR 0.152.
 */
package com.integ.tasker.signals;

import com.integ.tasker.signals.SignalProfile;
import com.integ.tasker.signals.SignalProfilesCollection;
import com.integ.tasker.workspaces.WorkspaceFile;
import com.integpg.janoslib.logger.FileLog;
import com.integpg.janoslib.logger.LogOptions;
import com.integpg.janoslib.logger.Logger;
import com.integpg.janoslib.system.Application;
import java.util.Json;

public class SignalConfiguration {
    private static final Logger LOG = FileLog.getHalfBackupLog(new LogOptions(Application.getAppName() + "_signals.log"));
    private final WorkspaceFile _workspaceConfigurationFile;
    private final SignalProfilesCollection _signalProfileCollection = new SignalProfilesCollection();

    public SignalConfiguration(WorkspaceFile workspaceConfigurationFile) {
        this._workspaceConfigurationFile = workspaceConfigurationFile;
    }

    public SignalProfilesCollection getSignalProfilesCollection() {
        return this._signalProfileCollection;
    }

    public void loadConfiguration(Json[] signalListJsonArray) throws Throwable {
        if (null == signalListJsonArray || 0 == signalListJsonArray.length) {
            return;
        }
        this._signalProfileCollection.clear();
        for (Json signalJson : signalListJsonArray) {
            SignalProfile signalProfile = new SignalProfile(signalJson);
            this._signalProfileCollection.put(signalProfile);
        }
        this._signalProfileCollection.put(SignalProfile.ANY_INPUT);
        this._signalProfileCollection.put(SignalProfile.ANY_OUTPUT);
    }
}

