function parseControlAction(json) {
    var method = json.Method;

    switch (method) {
        case 'Function':
            return new ControlFunction();

        case 'WhileLoop':
            return new WhileLoop();

        case 'ForLoop':
            return new ForLoop();

        case 'IfBlock':
            return new IfBlock();

        case 'IfElseBlock':
            return new IfElseBlock();

        case 'Switch':
            return new SwitchBlock();

        // we must leave the set variable check even though we moved it to 'other' so that
        // old workspaces dont break
        case 'SetVariable':
            return new SetVariable();

        default:
            throw new Error('Unknown Action Method: ' + JSON.stringify(json, null, 2));
    }
}



///////////////////////////////////////////////////////////////////////////////////////////////////
//
//                                         Control Actions
//
///////////////////////////////////////////////////////////////////////////////////////////////////

class IfBlock extends Actions {
    constructor(conditional) {
        super();
        this.Type = 'Control';
        this.Method = 'IfBlock';
        this.Params.Conditional = conditional;
    }

    editTemplate() {
        return 'If <input class="form-control" ng-model="action.Params.Conditional" style="width:600px" data-toggle="tooltip" title="A conditional expresssion that evaluates to true or false"/>' +
            ' <a href="help/#?blockId=controlstructures-ifblock" target="blank" style="font-size:16px;">' +
            ' <i class="fa fa-question-circle text-primary"></i></a> then';
    }
}



class IfElseBlock extends Actions {
    constructor(conditional) {
        super();
        this.Type = 'Control';
        this.Method = 'IfElseBlock';
        this.Params.Conditional = conditional;
        this.Params.ElseIfs = null;
        this.Params.ElseActions = null;
    }


    parse(json) {
        super.parse(json);

        if (this.Params.ElseActions) {
            for (var i = 0; i < this.Params.ElseActions.length; i++) {
                var elseActionJson = this.Params.ElseActions[i];
                this.Params.ElseActions[i] = parseAction(elseActionJson, this);
            }
        }

        if (this.Params.ElseIfs) {
            for (var i = 0; i < this.Params.ElseIfs.length; i++) {
                var elseIf = this.Params.ElseIfs[i];
                for (var j = 0; j < elseIf.Actions.length; j++) {
                    var elseIfActionJson = elseIf.Actions[j];
                    this.Params.ElseIfs[i].Actions[j] = parseAction(elseIfActionJson, this);
                }
            }
        }
    }


    addElseIf() {
        if (!this.Params.ElseIfs) this.Params.ElseIfs = [];
        this.Params.ElseIfs.push({ Conditional: "", Actions: [] });
    }


    removeElseIf(elseIfIndex) {
        this.Params.ElseIfs.splice(elseIfIndex, 1);
    }


    addElse() {
        if (!this.Params.ElseActions) this.Params.ElseActions = [];
    }


    removeElse() {
        this.Params.ElseActions = null;
    }


    editTemplate() {
        return 'If <input class="form-control" ng-model="action.Params.Conditional" style="width:600px"/> then';
    }


    getAdditionalHtml() {
        var additionalHtml = Actions.prototype.getAdditionalHtml() +
            '\r\n<div style="margin: 4px 12px;">\r\n' +
            '</div>\r\n';

        additionalHtml += '<div ng-repeat="elseIf in action.Params.ElseIfs track by $index">' +
            '<span class="form-inline"><a href="javascript: void(0);" ng-click="action.removeElseIf($index)"><i class="fa fa-minus text-danger" style="margin-right: 8px;" aria-hidden="true"></i></a> ' +
            'Else If <input class="form-control" ng-model="elseIf.Conditional" style="width:600px"/> then</sapn>' +
            '\r\n<div style="margin: 4px 24px; border-left: 1px solid #333; padding: 8px;">\r\n' +
            '  <action-block action="action" actions="elseIf.Actions" edit="edit" parent="parent" controller="controller"></action-block>\r\n' +
            '</div>\r\n' +
            '</div>';

        additionalHtml += '<add-else-if-block action="action" edit="edit" parent="parent" controller="controller"></add-else-if-block><br />\r\n';

        additionalHtml += '<div ng-if="action.Params.ElseActions == null"><a href="javascript: void(0);" class="text-success" ng-click="action.addElse()">' +
            '<i class="fa fa-plus" aria-hidden="true"></i> Add Else</a></div>' +
            '<div ng-if="action.Params.ElseActions != null">' +
            '<span class="form-inline"><a href="javascript: void(0);" ng-click="action.removeElse()"><i class="fa fa-minus text-danger" style="margin-right: 8px;" aria-hidden="true"></i></a> Else\r\n' +
            '\r\n<div style="margin: 4px 24px; border-left: 1px solid #333; padding-left: 8px;">\r\n' +
            '  <action-block action="action" actions="action.Params.ElseActions" edit="edit" parent="parent" controller="controller"></action-block>\r\n' +
            '</div></div>\r\n';

        return additionalHtml;
    }
}



// class SwitchBlock extends Actions {
//     constructor(conditional) {
//         super();
//         this.Type = 'Control';
//         this.Method = 'SwitchBlock';
//         this.Params.Conditional = conditional;
//         this.Params.ElseActions = [];
//     }


//     parse(json) {
//         super.parse(json);

//         for (var i = 0; i < this.Params.ElseActions.length; i++) {
//             var actionJson = this.Params.ElseActions[i];
//             this.Params.ElseActions[i] = parseAction(actionJson, this);
//         }
//     }


//     editTemplate() {
//         return 'Switch <input class="form-control" ng-model="action.Params.Conditional" style="width:600px"/>';
//     }


//     getAdditionalHtml() {
//         return Actions.prototype.getAdditionalHtml() +
//             '\r\n<div style="margin: 4px 12px;">\r\n' +
//             '  Else\r\n' +
//             '</div>\r\n' +
//             '\r\n<div style="margin: 4px 24px; border-left: 1px solid #333; padding-left: 8px;">\r\n' +
//             '  <a href="javascript: void(0)" ng-click="" class="text-success">\r\n' +
//             '  <i class="fa fa-plus" aria-hidden="true"></i> Add ElseIf</a><br>\r\n' +
//             '</div>\r\n' +
//             '\r\n<div style="margin: 4px 24px; border-left: 1px solid #333; padding-left: 8px;">\r\n' +
//             '  <action-block action="action" actions="action.Params.ElseActions" edit="edit" parent="parent" controller="controller"></action-block>\r\n' +
//             '</div>\r\n';
//     }
// }



class ForLoop extends Actions {
    constructor(variable, from, to) {
        super();
        this.Type = 'Control';
        this.Method = 'ForLoop';
        this.Params.Variable = variable;
        this.Params.From = from;
        this.Params.To = to;
    }

    editTemplate() {
        return 'Loop <input class="form-control" ng-model="action.Params.Variable" data-toggle="tooltip" title="Variable Name"' +
            '   name="loop-variable-' + guid() + '" required />' +
            ' from <input class="form-control" ng-model="action.Params.From" data-toggle="tooltip" title="Starting Variable (Inclusive)"' +
            '   name="loop-from-' + guid() + '" required />' +
            ' to <input class="form-control" ng-model="action.Params.To" data-toggle="tooltip" title="Ending Variable (Inclusive)"' +
            '   name="loop-to-' + guid() + '" required /> ';
    }
}



class WhileLoop extends Actions {
    constructor(conditional) {
        super();
        this.Type = 'Control';
        this.Method = 'WhileLoop';
        this.Params.Conditional = conditional;
    }

    editTemplate() {
        return 'While <input class="form-control" ng-model="action.Params.Conditional" style="width:600px" data-toggle="tooltip" title="A conditional expresssion that evaluates to true or false"/>';
    }
}