function parseNetworkAction(json) {
    var method = json.Method;

    switch (method) {
        case 'TcpSend':
            return new TcpSend();

        case 'EmailSend':
            return new EmailEntry();

        case 'EmailProfileSend':
            return new EmailProfile();

        case 'SNMPTrap':
            return new SNMPTrap();

        default:
            throw new Error('Unknown Network Action Method: ' + JSON.stringify(json, null, 2));
    }
}



class NetworkAction extends Action {
    constructor() {
        super();
        this.Type = 'Network';
        this.Method = 'void';
        this.Params = {};
    }
}


class TcpSend extends NetworkAction {
    constructor(host, port, message) {
        super();
        this.Method = 'TcpSend';
        this.Params.Host = host;
        this.Params.Port = port;
        this.Params.Message = message;
    }

    editTemplate() {
        var template = 'Tcp Send to ' +
            '<select name="tcpsend-device" class="form-control" ng-model="action.Params.DeviceGUID" ng-options="device.GUID as device.Name for device in controller.getDeviceProfiles()"' +
            '  data-toggle="tooltip" title="Select a Device that the following data wil be sent to" required>\r\n' +
            '   <option value=""></option></select>\r\n' +
            ' the following message' +
            ' <input name="tcpsend-message" class="form-control" type="text" ng-model="action.Params.Message" ' +
            '  data-toggle="tooltip" title="The data to be sent to the selected device.  Escaped cahracters will be converted before being sent.  If special characters are needed, please use \\x## to send the ASCII hex value." style="width:300px;" required />\r\n' +
            ' ';
        return template;
    }
}



class EmailEntry extends NetworkAction {
    constructor(toRecipient, subject, body) {
        super();
        this.Method = 'EmailSend';
        this.Params.ToRecipient = toRecipient;
        this.Params.Subject = subject;
        this.Params.Body = body;
    }

    editTemplate() {
        var template = 'Email To <input name="' + guid() + '" required type="text" class="form-control" ng-model="action.Params.ToRecipient" data-toggle="tooltip" title="Recipient Address"> ' +
            'Subject <input name="' + guid() + '" required type="text" class="form-control" ng-model="action.Params.Subject" data-toggle="tooltip" title="Subject"><br>' +
            '<textarea name="' + guid() + '" required rows="4" cols="50" class="form-control" ng-model="action.Params.Body" data-toggle="tooltip" title="Body" style="margin-left: 52px; margin-top: 8px;">';
        return template;
    }
}



class EmailProfile extends NetworkAction {
    constructor(profileName) {
        super();
        this.Method = 'EmailProfileSend';
        this.Params.ProfileName = profileName;
    }

    editTemplate() {
        var template = 'Send Email Profile for <input name="' + guid() + '" required type="text" class="form-control" ng-model="action.Params.ProfileName">';
        return template;
    }
}



class SNMPTrap extends NetworkAction {
    constructor() {
        super();
        this.Method = 'SNMPTrap';
        this.Params = {};
    }

    editTemplate() {
        var template = 'Send SNMP Trap for OID ' +
            '<input name="' + guid() + '" required type="text" class="form-control" ng-model="action.Params.OID" style="width: 225px;"> Data ' +
            '<input name="' + guid() + '" required type="text" class="form-control" ng-model="action.Params.Message" style="width: 225px;"> to ' +
            '<select name="tcpsend-device" class="form-control" ng-model="action.Params.DeviceGUID" ng-options="device.GUID as device.Name for device in controller.getSNMPDevices()"' +
            '  data-toggle="tooltip" title="Select a SNMP Device">\r\n' +
            '   <option value=""></option>\r\n' +
            '</select>\r\n';
        return template;
    }
}