function JnrWebsocket() {
    var _service = this;

    _service.onLoggedIn = null;
    _service.onReplyMessage = null;

    var _onLoggedInListeners = [];
    var _onMessageListeners = [];

    var _registryReadCallbacks = [];
    var _registrySubscriptionPromises = [];
    var _registryListingCallbacks = [];
    var _fileListingCallbacks = [];
    var _fileListPromises = [];
    var _readFileCallbacks = [];
    var _writeFileCallbacks = [];
    var _mkDirCallbacks = [];
    var _renameFilePromises = [];
    var _removeFilePromises = [];
    var _readDeviceCallbacks = [];


    // our websocket communication object
    var _comm;
    _service.loggedIn = false;
    var _appId;
    var _pingAcknowledged = true;
    var _nextPing = new Date().getTime();

    _service.onOpened = function () { };
    _service.onClosed = function () { };
    _service.onError = function () { };
    _service.pingFailed = null;

    _service.initPing = function (appId) {
        _appId = appId;
        setInterval(_service.sendPing, 5000);
    };




    _service.addEventListener = function (event, callback) {
        if ('onLoggedIn' === event) _service.addOnLoggedInListener(callback);
        else if ('onMessage' === event) _service.addOnMessageListener(callback);
    };


    _service.addOnLoggedInListener = function (callback) {
        _onLoggedInListeners.push(callback);
    };


    _service.addOnMessageListener = function (callback) {
        _onMessageListeners.push(callback);
    };






    // a function to allert all of the registered listeners for the 
    function alertListeners(listeners, json) {
        listeners.forEach(function (listener) {
            if (null == json) listener();
            else listener(json);
        });
    }



    _service.isLoggedIn = function () {
        return _service.loggedIn;
    };


    var onmessage = function (evt) {
        var json = JSON.parse(evt.data);

        if (json.Message === "Monitor") {
            if (!_service.loggedIn) {
                _service.loggedIn = true;
                if (_service.onLoggedIn) {
                    _service.onLoggedIn();
                }
                alertListeners(_onLoggedInListeners, json);
            }
        }

        //
        else if (json.Message === "File List Response") {
            if (json.Status === "Fail") {
            } else {
                var folder = json.Folder;
                folder = folder.trimStrEnd('/');
                var deferred = _fileListPromises[folder];
                if (null !== deferred) {
                    deferred.resolve(json);
                    _fileListPromises[folder] = null;
                }
            }
        }

        //
        else if (json.Message === "Registry Response") {
            for (var key in json.Keys) {
                if (json.Keys.hasOwnProperty(key)) {
                    var value = json.Keys[key];

                    var callbackIndex = key;
                    if (json.Meta && json.Meta.Hash) callbackIndex = json.Meta.Hash;

                    var callback = _registryReadCallbacks[callbackIndex];
                    if (callback && null !== callback) {
                        callback(key, value);
                    }
                }
            }
        }

        //
        else if (json.Message === "Registry Update") {
            for (var key in json.Keys) {
                if (json.Keys.hasOwnProperty(key)) {
                    var value = json.Keys[key];
                    var callback = _registrySubscriptionPromises[key.toLowerCase()];
                    if (callback && null !== callback) {
                        callback(key, value);
                    }
                }
            }
        }

        //
        else if (json.Message === "Registry List Response") {
            var node = json.Meta.Node;
            var callback = _registryListingCallbacks[node];
            if (null !== callback) {
                callback(node, json.Keys);
            }
        }

        //
        else if (json.Message === "File Read Response") {
            var file = json.File;
            var callbackIndex = file;
            if (json.Meta && json.Meta.Hash) callbackIndex = json.Meta.Hash;

            var callback = _readFileCallbacks[callbackIndex];
            if (callback) {
                callback(json);
            }
        }

        // 
        else if (json.Message === "File Write Response") {
            console.log(json);
            var file = json.File;
            var callbackIndex = file;
            if (json.Meta && json.Meta.Hash) callbackIndex = json.Meta.Hash;

            var callback = _writeFileCallbacks[callbackIndex];
            console.log('write response hash for ' + file + ': ' + json.Meta.Hash + ' callback: ' + callback);
            if (callback) {
                callback(json);
            }
        }

        // 
        else if (json.Message === "File Rename Response") {
            var filename = json.Old;
            var deferred = _renameFilePromises[filename];
            if (null !== deferred) {
                deferred.resolve(json);
                _renameFilePromises[filename] = null;
            }
        }

        //
        else if (json.Message === "File Remove Response") {
            var filename = json.Succeed[0];
            var deferred = _removeFilePromises[filename];
            if (null !== deferred) {
                deferred.resolve(json);
                _removeFilePromises[filename] = null;
            }
        }

        //
        else if (json.Message === "File Mkdir Response") {
            var folder = json.Folder;
            var callbackIndex = folder;
            if (json.Meta && json.Meta.Hash) callbackIndex = json.Meta.Hash;

            var callback = _mkDirCallbacks[callbackIndex];
            if (callback) {
                callback(json);
            }
        }

        // 
        else if (json.Message === "Read Devices Response") {
            for (var deviceIndex in json.Devices) {
                var device = json.Devices[deviceIndex];
                var deviceId = device.Address;
                var callback = _readDeviceCallbacks[deviceId];
                if (null !== callback) {
                    callback(device);
                }
            }
        }

        //
        else if (json.Message === "Reply Message") {
            //            if (_appId === json.Number) {
            if ("ping-resp" === json.Content) {
                console.log(_service.wsUri + ': ping acknolwedged');
            } else if (_service.onReplyMessage) {
                _service.onReplyMessage(json);
            } else {
                try {
                    var contentJson = JSON.parse(json.Content);
                    alertListeners(_onMessageListeners, contentJson);
                } catch (err) { }
            }
            // any message received from the application should acknowledge the ping
            _pingAcknowledged = true;
            //            }
        }
    };


    _service.connect = function (uri) {
        _comm = new Comm();
        if (uri) _comm.wsUri = uri;
        _comm.onopen = _service.onOpened;
        _comm.onclose = function () {
            _service.loggedIn = false;
            if (_service.onClosed)
                _service.onClosed();
        };
        _comm.onerror = _service.onError;
        _comm.onmessage = onmessage;
        _comm.connect();
    };


    _service.getWsUri = function () {
        return _comm.wsUri;
    };


    _service.enableCommLogging = function () {
        _comm.enableCommLogging = true;
    };


    _service.readRegistryKey = function (key, callback) {
        _service.readRegistryKeys([key], callback);
    };


    _service.readRegistryKeys = function (keys, callback) {
        var metaHash = Math.floor(Math.random() * 10000);
        _registryReadCallbacks[metaHash] = callback;

        for (var keyIndex in keys) {
            var key = keys[keyIndex];
            if (!_registryReadCallbacks[key] || null == _registryReadCallbacks[key]) {
                _registryReadCallbacks[key] = [];
            }
            var index = _registryReadCallbacks[key].indexOf(callback);
            if (-1 === index) {
                _registryReadCallbacks[key].push(callback);
            }
        }

        var jsonRequest = { "Message": "Registry Read", "Keys": keys, Meta: { Hash: metaHash } };
        _comm.sendJson(jsonRequest);
    };


    _service.registrySubscription = function (key, callback) {
        var metaHash = Math.floor(Math.random() * 10000);
        _registryReadCallbacks[metaHash] = callback;

        _registrySubscriptionPromises[key.toLowerCase()] = callback;
        var jsonRequest = {
            "Message": "Registry Read",
            "Keys": [key],
            Meta: { Hash: metaHash }
        };
        _comm.sendJson(jsonRequest);
    };


    _service.registryWrite = function (key, value) {
        var jsonRequest = {
            "Message": "Registry Write",
            "Keys": {}
        };
        jsonRequest.Keys[key] = value.toString();
        _comm.sendJson(jsonRequest);
    };


    _service.getRegistryListing = function (node, callback) {
        _registryListingCallbacks[node] = callback;
        var jsonRequest = { Message: "Registry List", "Meta": { "Op": "registry", "Node": node }, "Node": node };
        _comm.sendJson(jsonRequest);
    };


    _service.getFileListing = function (folder) {
        folder = folder.trimStrEnd('/');
        var deferred = $.Deferred();
        _fileListPromises[folder] = deferred;
        var jsonRequest = { Message: "File List", Folder: folder };
        _comm.sendJson(jsonRequest);
        return deferred.promise();
    };


    _service.readFile = function (filename, callback) {
        if (!filename.startsWith('/')) {
            filename = '/' + filename;
        }
        _readFileCallbacks[filename] = callback;
        var metaHash = Math.floor(Math.random() * 10000);
        _readFileCallbacks[metaHash] = callback;
        var jsonRequest = { Message: "File Read", File: filename, Meta: { Hash: metaHash } };
        _comm.sendJson(jsonRequest);
    };


    _service.downloadFile = function (filename) {
        if (!filename.startsWith('/')) {
            filename = '/' + filename;
        }
        var deferred = $.Deferred();
        _readFilePromises[filename] = deferred;

        var requestid = Math.floor(Math.random() * 1000000000000000);
        var url = document.baseURI;
        if (!url)
            url = location.href;
        var pos = url.indexOf("//");
        if (pos > 0) {
            pos = url.indexOf("/", pos + 2);
            if (pos > 0)
                url = url.substring(0, pos);
            url += "/query.cgi?request=" + requestid;
        }

        var jsonRequest = { Message: "File Read", Meta: url, File: filename, RequestID: requestid };
        _comm.sendJson(jsonRequest);
        return deferred.promise();
    };


    _service.writeFile = function (filename, content, callback) {
        if (!filename.startsWith('/')) {
            filename = '/' + filename;
        }
        var fileData = btoa(content);
        var metaHash = Math.floor(Math.random() * 10000);

        // large files must be sent in multiple write messages as described by the JMP protocol wiki:
        //
        //  For very large files the "File Write" message can become huge. This can lead to
        //  memory and performance concerns. Fortunately, you can optionally use the boolean 
        //  parameter "Append" to break file writes into manageable blocks.
        //
        //  To append to an existing file you use the "File Write" message exactly as described 
        //  above. You must include an additional parameter named "Append" set to the value of 
        //  "true". In this case the file must previously exist and the data included with the 
        //  "Data" parameter will be appended to it. The write operation will fail if the file 
        //  is not present. So to transfer a large file using multiple messages the first must 
        //  not indicate "Append". It would be included only in subsequent "File Write" messages. 
        //  This will insure that the resulting file will be as you are expecting.
        //
        //  In this case the returned "Size" parameter will increase as the size of the target 
        //  file increases by the "NumWritten" byte count.
        var numWritten = 0;
        var writeChunk = function () {
            var bytesRemaining = content.length - numWritten;
            var bytesToWrite = bytesRemaining;
            if (0 < bytesRemaining) {
                if (16384 < bytesRemaining) {
                    bytesToWrite = 16384;
                    _writeFileCallbacks[metaHash] = function (json) {
                        if ('Fail' != json.Status) {
                            // update numWritten and call to write the next chunk
                            numWritten = json.Size;
                            writeChunk();
                        } else {
                            // uh oh
                            callback(json);
                        }
                    };

                } else {
                    if (callback) _writeFileCallbacks[metaHash] = callback;
                }
            }

            fileData = btoa(content.substring(numWritten, numWritten + bytesToWrite));
            console.log(fileData.length);
            var jsonRequest = {
                Message: "File Write",
                File: filename,
                Size: bytesToWrite,
                Encoding: "base64",
                Data: fileData,
                Meta: { Hash: metaHash }
            };
            if (0 != numWritten) jsonRequest["Append"] = true;
            _comm.sendJson(jsonRequest);
        }

        // initial writeChunk call
        writeChunk();
    };


    _service.renameFile = function (oldFilename, newFilename) {
        var deferred = $.Deferred();
        _renameFilePromises[oldFilename] = deferred;
        var jsonRequest = { Message: "File Rename", Old: oldFilename, New: newFilename };
        _comm.sendJson(jsonRequest);
        return deferred.promise();
    };


    _service.removeFile = function (filename) {
        var deferred = $.Deferred();
        _removeFilePromises[filename] = deferred;
        var jsonRequest = { Message: "File Remove", Files: [filename] };
        _comm.sendJson(jsonRequest);
        return deferred.promise();
    };


    _service.mkDir = function (directoryName, callback) {
        var metaHash = Math.floor(Math.random() * 10000);
        _mkDirCallbacks[metaHash] = callback;
        var jsonRequest = {
            Message: "File Mkdir",
            Folder: directoryName,
            Meta: { Hash: metaHash }
        };
        _comm.sendJson(jsonRequest);
    };


    _service.readDevices = function (deviceIds, callback) {
        for (var deviceIndex in deviceIds) {
            var deviceId = deviceIds[deviceIndex];
            _readDeviceCallbacks[deviceId] = callback;
        }
        var jsonRequest = { Message: "Read Devices", Devices: deviceIds };
        _comm.sendJson(jsonRequest);
    };


    _service.postMessage = function (number, message) {
        var messageString = JSON.stringify(message);
        var jsonRequest = { Message: "Post Message", Number: number, Content: messageString };
        _comm.sendJson(jsonRequest);
    };



    _service.sendJson = function (jsonMessage) {
        _comm.sendJson(jsonMessage);
    }



    _service.close = function () {
        _comm.close();
    }
}