/*
 * Decompiled with CFR 0.152.
 */
package com.integ.tasker.triggers;

import com.integ.janoslib.Version;
import com.integ.janoslib.messagepump.MessagePumpEngine;
import com.integ.tasker.Unloadable;
import com.integ.tasker.WorkspaceConfigurationFile;
import com.integ.tasker.triggers.TriggerMonitor;
import com.integ.tasker.triggers.TriggerProfile;
import com.integ.tasker.triggers.TriggerProfilesCollection;
import com.integ.tasker.web.messages.ErrorMessage;
import com.integpg.janoslib.logger.FileLog;
import com.integpg.janoslib.logger.LogOptions;
import com.integpg.janoslib.logger.LogTypes;
import com.integpg.janoslib.logger.Logger;
import com.integpg.janoslib.system.Application;
import java.util.Json;

public class TriggersConfiguration
implements Unloadable {
    public static final Logger LOG = FileLog.getLog(new LogOptions(Application.getAppName() + "_triggers.log").setLogType(LogTypes.HalfBak));
    private final WorkspaceConfigurationFile _workspaceConfigurationFile;
    private final TriggerMonitor _triggerMonitor;

    public TriggersConfiguration(WorkspaceConfigurationFile workspaceConfigurationFile) {
        this._workspaceConfigurationFile = workspaceConfigurationFile;
        this._triggerMonitor = new TriggerMonitor(workspaceConfigurationFile);
        this._workspaceConfigurationFile.addUnloadable(this);
    }

    public WorkspaceConfigurationFile getWorkspaceConfigurationFile() {
        return this._workspaceConfigurationFile;
    }

    public TriggerMonitor getTriggerMonitor() {
        return this._triggerMonitor;
    }

    public void loadConfiguration(Json[] triggerListJsonArray) throws Throwable {
        if (null == triggerListJsonArray || 0 == triggerListJsonArray.length) {
            return;
        }
        try {
            String workspaceConfigurationVersion = this._workspaceConfigurationFile.getVersion();
            System.out.println("workspaceConfigurationVersion = " + workspaceConfigurationVersion);
            Version thisVersion = Version.parse(workspaceConfigurationVersion);
            System.out.println("thisVersion = " + thisVersion);
            Version requiredVersion = new Version(5, 2);
            System.out.println("requiredVersion = " + requiredVersion);
            System.out.println("requiredVersion.compareTo(thisVersion) = " + requiredVersion.compareTo(thisVersion));
            if (requiredVersion.compareTo(thisVersion) > 0) {
                System.out.println("UPGRADE Triggers!");
                this.upgradeTriggers_5_2(triggerListJsonArray);
                this._workspaceConfigurationFile.setVersion("5.2");
                this._workspaceConfigurationFile.setUpdatedTriggers(triggerListJsonArray);
            }
            TriggerProfilesCollection.clear();
            for (Json triggerJson : triggerListJsonArray) {
                LOG.info("triggerJson: " + triggerJson);
                TriggerProfile triggerProfile = new TriggerProfile(this, triggerJson);
                TriggerProfilesCollection.put(triggerProfile.getName(), triggerProfile);
            }
            this._triggerMonitor.start();
        }
        catch (Throwable ex) {
            LOG.error("error loading triggers for " + this._workspaceConfigurationFile.getName(), ex);
            ErrorMessage message = new ErrorMessage(ex);
            MessagePumpEngine.postMessage(message.build());
        }
    }

    @Override
    public void unload() {
        this._triggerMonitor.stop();
    }

    private void upgradeTriggers_5_2(Json[] triggerListJsonArray) {
        for (int i = 0; i < triggerListJsonArray.length; ++i) {
            Json triggerProfileJson = triggerListJsonArray[i];
            LOG.info("old triggerProfileJson: " + triggerProfileJson);
            Json paramsJson = (Json)triggerProfileJson.get("Params");
            System.out.println("paramsJson = " + paramsJson);
            Json triggerJson = (Json)paramsJson.get("Trigger");
            System.out.println("triggerJson = " + triggerJson);
            paramsJson.remove("Trigger");
            Json newTriggerJsonObject = new Json();
            newTriggerJsonObject.put("Params", (Object)triggerJson);
            System.out.println("newTriggerJsonObject = " + newTriggerJsonObject);
            newTriggerJsonObject.put("GUID", (Object)this.createGuid());
            System.out.println("newTriggerJsonObject = " + newTriggerJsonObject);
            Json signalJson = (Json)triggerJson.get("Signal");
            String selectedDeviceString = signalJson.getString("SelectedDevice");
            if ("DIN".equals(selectedDeviceString) || "ROUT".equals(selectedDeviceString)) {
                newTriggerJsonObject.put("Type", (Object)"DiscreteSignalTrigger");
            } else {
                newTriggerJsonObject.put("Type", (Object)"ContinuousSignalTrigger");
            }
            System.out.println("newTriggerJsonObject = " + newTriggerJsonObject);
            paramsJson.put("Trigger", (Object)newTriggerJsonObject);
            System.out.println("paramsJson = " + paramsJson);
            Json resetJson = (Json)paramsJson.get("Reset");
            System.out.println("resetJson = " + resetJson);
            paramsJson.remove("Reset");
            Json newResetJsonObject = new Json();
            newResetJsonObject.put("Params", (Object)resetJson);
            System.out.println("newResetJsonObject = " + newResetJsonObject);
            newResetJsonObject.put("GUID", (Object)this.createGuid());
            System.out.println("newResetJsonObject = " + newResetJsonObject);
            signalJson = (Json)resetJson.get("Signal");
            selectedDeviceString = signalJson.getString("SelectedDevice");
            if ("DIN".equals(selectedDeviceString) || "ROUT".equals(selectedDeviceString)) {
                newResetJsonObject.put("Type", (Object)"DiscreteSignalReset");
            } else {
                newResetJsonObject.put("Type", (Object)"ContinuousSignalReset");
            }
            System.out.println("newResetJsonObject = " + newResetJsonObject);
            paramsJson.put("Reset", (Object)newResetJsonObject);
            System.out.println("paramsJson = " + paramsJson);
            triggerProfileJson.put("Params", (Object)paramsJson);
            LOG.info("new triggerProfileJson: " + triggerProfileJson);
        }
    }

    private String createGuid() {
        String guid = String.format("%s%s-%s-%s-%s-%s%s", this.s4(), this.s4(), this.s4(), this.s4(), this.s4(), this.s4(), this.s4());
        return guid;
    }

    private String s4() {
        int r4 = (int)Math.floor(Math.random() * 65536.0);
        return String.format("%04X", r4).toLowerCase();
    }
}

