/*
 * Decompiled with CFR 0.152.
 */
package com.integ.tasker.triggers;

import com.integ.tasker.triggers.Reset;
import com.integ.tasker.triggers.Trigger;
import com.integ.tasker.triggers.TriggersConfiguration;
import com.integ.tasker.triggers.resettypes.ContinuousSignalReset;
import com.integ.tasker.triggers.resettypes.DelayedReset;
import com.integ.tasker.triggers.resettypes.NullReset;
import com.integ.tasker.triggers.resettypes.ResetFactory;
import com.integ.tasker.triggers.triggertypes.ContinuousSignalTrigger;
import com.integ.tasker.triggers.triggertypes.TriggerFactory;
import java.util.Json;

public class TriggerProfile {
    private String _name;
    private boolean _enabled = false;
    private Trigger _trigger;
    private Reset _reset;
    private String _taskName;

    public TriggerProfile(TriggersConfiguration triggersConfiguration, Json triggerProfileJson) {
        System.out.println("TriggerMonitor.triggerProfileJson: " + triggerProfileJson);
        this._name = triggerProfileJson.getString("Name");
        Json paramsJson = (Json)triggerProfileJson.get("Params");
        if (null != paramsJson.get("Enabled")) {
            this._enabled = (Boolean)paramsJson.get("Enabled");
            System.out.println("_enabled: " + this._enabled);
            if (!this._enabled) {
                return;
            }
        }
        this._taskName = paramsJson.getString("TaskName");
        System.out.println("_taskName: " + this._taskName);
        Json triggerJson = (Json)paramsJson.get("Trigger");
        try {
            this._trigger = TriggerFactory.getTrigger(triggerJson);
            if (null != this._trigger) {
                this._trigger.setTriggerProfile(this);
                this._trigger.setWorkspaceConfigurationFile(triggersConfiguration.getWorkspaceConfigurationFile());
                this._trigger.setTaskName(this._taskName);
                if (this._trigger instanceof ContinuousSignalTrigger) {
                    triggersConfiguration.getTriggerMonitor().addTrigger(this._trigger);
                }
            } else {
                this._enabled = false;
            }
        }
        catch (Exception ex) {
            TriggersConfiguration.LOG.error(new Exception(String.format("error loading trigger for %s", this._name), ex));
        }
        if (this._enabled) {
            Json resetJson = (Json)paramsJson.get("Reset");
            if (null != resetJson) {
                try {
                    this._reset = ResetFactory.getReset(resetJson);
                }
                catch (Exception ex) {
                    TriggersConfiguration.LOG.error(new Exception(String.format("error loading trigger for %s", this._name), ex));
                }
            } else if (null == this._reset) {
                if (this._trigger instanceof ContinuousSignalTrigger) {
                    TriggersConfiguration.LOG.info("create default DelayedReset for " + this._name);
                    this._reset = new DelayedReset(new Json("{\"Params\":{\n\"DelayTime\":10\n}"));
                } else {
                    this._reset = new NullReset();
                }
            }
            if (null != this._reset) {
                this._reset.setWorkspaceConfigurationFile(triggersConfiguration.getWorkspaceConfigurationFile());
                this._trigger.setReset(this._reset);
                this._reset.setTrigger(this._trigger);
                if (this._reset instanceof ContinuousSignalReset || this._reset instanceof DelayedReset || this._reset instanceof NullReset) {
                    triggersConfiguration.getTriggerMonitor().addReset(this._reset);
                }
            }
        }
    }

    public String getName() {
        return this._name;
    }

    public Trigger getTrigger() {
        return this._trigger;
    }

    public Reset getReset() {
        return this._reset;
    }

    public TriggersConfiguration getTriggersConfiguration() {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

