/*
 * Decompiled with CFR 0.152.
 */
package com.integ.tasker.triggers.resettypes;

import com.integ.janoslib.iolog.IoChannelEvent;
import com.integ.janoslib.iolog.IoChannelLogListener;
import com.integ.tasker.TaskerMain;
import com.integ.tasker.Unloadable;
import com.integ.tasker.signals.SignalProfile;
import com.integ.tasker.signals.SignalProfilesCollection;
import com.integ.tasker.triggers.Reset;
import com.integ.tasker.workspaces.WorkspaceFile;
import java.util.Json;

public class DiscreteSignalReset
extends Reset
implements IoChannelLogListener,
Unloadable {
    private final Json _paramsJson;
    private final String _signalProfileName;
    private final String _resetState;
    private SignalProfile _signalProfile;

    public DiscreteSignalReset(Json resetJson) {
        this._paramsJson = (Json)resetJson.get("Params");
        this._resetState = this._paramsJson.getString("State");
        Json resetSignalJson = (Json)this._paramsJson.get("Signal");
        this._signalProfileName = resetSignalJson.getString("Name");
    }

    @Override
    public void setWorkspaceConfigurationFile(WorkspaceFile workspaceConfigurationFile) {
        super.setWorkspaceConfigurationFile(workspaceConfigurationFile);
        this._workspaceConfigurationFile.addUnloadable(this);
        SignalProfilesCollection signalProfilesCollection = workspaceConfigurationFile.getSignalProfilesCollection();
        if (signalProfilesCollection.containsSignalProfileName(this._signalProfileName)) {
            this._signalProfile = signalProfilesCollection.getByName(this._signalProfileName);
        }
        if ("din".equalsIgnoreCase(this._signalProfile.DeviceType)) {
            TaskerMain.DIGITAL_INPUT_MONITOR.addDigitalInputListener(this);
        } else if ("rout".equalsIgnoreCase(this._signalProfile.DeviceType)) {
            TaskerMain.DIGITAL_OUTPUT_MONITOR.addDigitalOutputListener(this);
        }
    }

    @Override
    public void unload() {
        if ("din".equalsIgnoreCase(this._signalProfile.DeviceType)) {
            TaskerMain.DIGITAL_INPUT_MONITOR.removeDigitalInputListener(this);
        } else if ("rout".equalsIgnoreCase(this._signalProfile.DeviceType)) {
            TaskerMain.DIGITAL_OUTPUT_MONITOR.removeDigitalOutputListener(this);
        }
    }

    @Override
    public void onIoChannelEvent(IoChannelEvent ioEvent) {
        System.out.println("discrete Reset " + this.toString());
        System.out.println("Channel: " + ioEvent.Channel + ", _resetSignalProfile.Channel: " + this._signalProfile.Channel);
        if (ioEvent.Channel == this._signalProfile.Channel) {
            System.out.println("_resetState: " + this._resetState + ", digitalInput.State: " + ioEvent.State);
            if ("either".equalsIgnoreCase(this._resetState)) {
                this.resetTrigger();
            } else if (ioEvent.State && "high".equalsIgnoreCase(this._resetState)) {
                this.resetTrigger();
            } else if (!ioEvent.State && "low".equalsIgnoreCase(this._resetState)) {
                this.resetTrigger();
            }
        }
    }
}

