/*
 * Decompiled with CFR 0.152.
 */
package com.integ.tasker.triggers;

import com.integ.janoslib.iolog.IoChannelEvent;
import com.integ.janoslib.iolog.IoChannelLogListener;
import com.integ.janoslib.messagepump.MessagePumpEngine;
import com.integ.tasker.WorkspaceConfigurationFile;
import com.integ.tasker.signals.SignalProfile;
import com.integ.tasker.signals.SignalProfilesCollection;
import com.integ.tasker.tasks.Task;
import com.integ.tasker.tasks.TaskCollection;
import com.integ.tasker.triggers.AnalogReset;
import com.integ.tasker.triggers.AnalogTrigger;
import com.integ.tasker.triggers.DiscreteReset;
import com.integ.tasker.triggers.DiscreteTrigger;
import com.integ.tasker.triggers.Reset;
import com.integ.tasker.triggers.Trigger;
import com.integ.tasker.triggers.TriggerListener;
import com.integ.tasker.triggers.TriggerMonitorCollection;
import com.integ.tasker.triggers.TriggerObject;
import com.integ.tasker.webhandlers.ErrorMessage;
import com.integpg.janoslib.io.AppLog;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Json;

public class TriggerMonitor
implements Runnable,
IoChannelLogListener,
TriggerListener {
    private final WorkspaceConfigurationFile _workspaceConfigurationFile;
    private String _name;
    private boolean _enabled = false;
    private Trigger _trigger;
    private Json _triggerSignalJson;
    private SignalProfile _triggerSignalProfile;
    private Reset _reset;
    private Json _resetSignalJson;
    private SignalProfile _resetSignalProfile;
    private boolean _triggered;
    private String _taskName;
    private Thread _thread;
    private boolean _initial = true;
    private boolean _cancelled = false;

    @Override
    public void onIoChannelEvent(IoChannelEvent ioEvent) {
        try {
            Hashtable<String, TriggerMonitor> monitors = TriggerMonitorCollection.getMonitors();
            Enumeration<TriggerMonitor> enumeration = monitors.elements();
            while (enumeration.hasMoreElements()) {
                TriggerMonitor monitor = enumeration.nextElement();
                monitor.checkMonitor();
            }
        }
        catch (Throwable ex) {
            AppLog.error(ex);
        }
    }

    public TriggerMonitor(Json signalJson, WorkspaceConfigurationFile workspaceConfigurationFile) {
        this._workspaceConfigurationFile = workspaceConfigurationFile;
        this.updateConfig(signalJson);
    }

    public String getName() {
        return this._name;
    }

    public void updateConfig(Json signalJson) {
        long start = System.currentTimeMillis();
        System.out.println("Signal Json: " + signalJson);
        this._name = signalJson.getString("Name");
        Json paramsJson = (Json)signalJson.get("Params");
        if (null != paramsJson.get("Enabled")) {
            this._enabled = (Boolean)paramsJson.get("Enabled");
            System.out.println("_enabled: " + this._enabled);
            if (!this._enabled) {
                return;
            }
        }
        this._taskName = paramsJson.getString("TaskName");
        System.out.println("_taskName: " + this._taskName);
        Json triggerJson = (Json)paramsJson.get("Trigger");
        System.out.println("triggerJson: " + triggerJson);
        if (null != triggerJson) {
            SignalProfilesCollection signalProfilesCollection = this._workspaceConfigurationFile.getSignalProfilesCollection();
            this._triggerSignalJson = (Json)triggerJson.get("Signal");
            System.out.println("_triggerSignalJson: " + this._triggerSignalJson);
            String triggerSignalProfileString = this._triggerSignalJson.getString("Name");
            if (signalProfilesCollection.containsSignalProfileName(triggerSignalProfileString)) {
                this._triggerSignalProfile = signalProfilesCollection.getByName(triggerSignalProfileString);
                Trigger trigger = null;
                if (null != triggerJson.get("Value")) {
                    trigger = new AnalogTrigger(this._triggerSignalProfile, triggerJson);
                } else if (null != triggerJson.get("State")) {
                    trigger = new DiscreteTrigger(this._triggerSignalProfile, triggerJson, this._taskName);
                }
                if (null == trigger) {
                    this._enabled = false;
                }
                this._trigger = trigger;
                System.out.println("_trigger: " + this._trigger);
            } else {
                this._enabled = false;
            }
            Json resetJson = (Json)paramsJson.get("Reset");
            System.out.println("resetJson: " + resetJson);
            if (null != resetJson) {
                this._resetSignalJson = (Json)resetJson.get("Signal");
                String resetSignalProfileString = this._resetSignalJson.getString("Name");
                if (signalProfilesCollection.containsSignalProfileName(resetSignalProfileString)) {
                    this._resetSignalProfile = signalProfilesCollection.getByName(resetSignalProfileString);
                    Reset reset = null;
                    if (null != resetJson.get("Value")) {
                        reset = new AnalogReset(this._resetSignalProfile, resetJson);
                    } else if (null != resetJson.get("State")) {
                        reset = new DiscreteReset(this._resetSignalProfile, resetJson);
                    }
                    this._reset = reset;
                    System.out.println("_reset: " + this._reset);
                }
            } else if (this._trigger instanceof AnalogTrigger) {
                this._reset = new AnalogReset(this._triggerSignalProfile, triggerJson);
                this._reset.makeReset();
            } else if (this._trigger instanceof DiscreteTrigger) {
                this._reset = new DiscreteReset(this._triggerSignalProfile, triggerJson);
                this._reset.makeReset();
            }
            if (this._enabled) {
                TriggerMonitorCollection.add(this);
            }
        } else {
            this._enabled = false;
        }
        long elapsed = System.currentTimeMillis() - start;
        System.out.println("\r\n\r\nLOADING TOOK: " + elapsed + "\r\n\r\n");
    }

    public void start() {
        if (this._enabled && null == this._thread) {
            this._cancelled = false;
            this._thread = new Thread(this);
            this._thread.setDaemon(true);
            this._thread.setName(this.getClass().getName() + ":" + this._name);
            this._thread.start();
        }
    }

    void stop() {
        try {
            AppLog.info("Stopping " + this._name);
            this._cancelled = true;
            this._thread.interrupt();
            this._thread.join();
        }
        catch (Exception e) {
            System.out.println("Exception handled: " + e.getMessage());
        }
    }

    @Override
    public void run() {
        while (!this._cancelled) {
            try {
                this.checkMonitor();
                Thread.sleep(100L);
            }
            catch (InterruptedException ex) {
                System.out.println(this._name + " interrupted");
                break;
            }
        }
        AppLog.info(this._name + " done.");
        this._thread = null;
    }

    private void checkMonitor() {
        try {
            if (!this._triggered) {
                this._triggered = this._trigger.checkForTrigger();
                if (this._triggered && !this._initial) {
                    AppLog.info(this._name + " checkMonitor TRIGGERED!");
                    if (this._enabled) {
                        try {
                            Task task = TaskCollection.GLOBAL.getByTaskName(this._taskName);
                            if (null != task) {
                                task.execute();
                            }
                        }
                        catch (Throwable ex) {
                            Throwable throwable = new Exception("error executing task by name: " + this._taskName).initCause(ex);
                            AppLog.error(throwable);
                            ErrorMessage message = new ErrorMessage(throwable);
                            MessagePumpEngine.postMessage(message.build());
                        }
                    }
                }
            } else {
                boolean bl = this._triggered = !this._reset.checkForReset();
                if (!this._triggered && !this._initial) {
                    AppLog.info(this._name + " RESET!");
                }
            }
            this._initial = false;
        }
        catch (Throwable ex) {
            AppLog.error(ex);
        }
    }

    @Override
    public void onTrigger(TriggerObject source) {
        AppLog.info(this._name + " onTrigger TRIGGERED!");
        if (this._enabled) {
            try {
                Task task = TaskCollection.GLOBAL.getByTaskName(this._taskName);
                if (null != task) {
                    task.execute();
                }
            }
            catch (Throwable ex) {
                Throwable throwable = new Exception("error executing task by name: " + this._taskName).initCause(ex);
                AppLog.error(throwable);
                ErrorMessage message = new ErrorMessage(throwable);
                MessagePumpEngine.postMessage(message.build());
            }
        }
    }

    private static enum SIGNAL_TYPE {
        DISCRETE,
        ANALOG;

    }
}

