/*
 * Decompiled with CFR 0.152.
 */
package com.integ.tasker.signals;

import com.integpg.janoslib.io.AppLog;
import java.util.Json;

public class SignalProfile {
    public String Name;
    public String DeviceType;
    public IO_TYPE IoType = IO_TYPE.Input;
    public int Channel;
    public String FieldName;

    public SignalProfile(Json signalProfileJson) {
        try {
            this.Name = signalProfileJson.getString("Name");
            System.out.println("Name: " + this.Name);
            this.DeviceType = signalProfileJson.getString("SelectedDevice");
            System.out.println("DeviceType: " + this.DeviceType);
            if (!signalProfileJson.containsKey("SelectedDeviceChannel") || "".equals(signalProfileJson.getString("SelectedDeviceChannel"))) {
                throw new Exception("Missing SelectedDeviceChannel");
            }
            String deviceChannelString = signalProfileJson.getString("SelectedDeviceChannel");
            if (Character.isDigit(deviceChannelString.charAt(0))) {
                this.Channel = Integer.parseInt(deviceChannelString);
            } else {
                if (deviceChannelString.toLowerCase().startsWith("out")) {
                    this.IoType = IO_TYPE.Output;
                }
                this.Channel = Integer.parseInt(deviceChannelString.substring(deviceChannelString.indexOf(" ") + 1));
            }
            System.out.println("Channel: " + this.Channel);
            this.FieldName = signalProfileJson.getString("SelectedDeviceVariable");
            System.out.println("FieldName: " + this.FieldName);
        }
        catch (Exception ex) {
            AppLog.error("error processing signal profile for " + this.Name + ": " + signalProfileJson, ex);
        }
    }

    public String toString() {
        return String.format("Signal Profile @%s, Name=%s, %s[%d].%s", Integer.toHexString(this.hashCode()), this.Name, this.DeviceType, this.Channel, this.FieldName);
    }

    public static enum IO_TYPE {
        Input,
        Output;

    }
}

