/*
 * Decompiled with CFR 0.152.
 */
package com.integ.scripting.objects;

import com.integ.scripting.ExpressionEngine;
import com.integ.scripting.exceptions.ScriptParserException;
import com.integ.scripting.exceptions.UnexpectedTokenException;
import com.integ.scripting.nodes.AbstractNode;
import com.integ.scripting.nodes.ValueNode;
import com.integ.scripting.objects.AbstractObjectCall;
import com.integ.tasker.tasks.Scope;
import com.integpg.janoslib.lexer.Token;
import com.integpg.janoslib.system.UnitConfig;
import com.integpg.system.IoEvent;
import com.integpg.system.Iolog;
import com.integpg.system.JANOS;
import java.util.Date;

public class RelayOutputObject
extends AbstractObjectCall {
    private static final Iolog INPUT_IO_LOG = new Iolog();
    private int _channel = -1;

    @Override
    public AbstractNode parse(ExpressionEngine parser) throws ScriptParserException {
        try {
            Token nextToken = parser.nextToken();
            if (nextToken.checkType(46)) {
                nextToken = parser.nextToken();
                if (!nextToken.checkType(0)) {
                    throw new UnexpectedTokenException("FIELD OR METHOD NAME", parser.currentToken());
                }
                switch (this._fieldOrMethodName = parser.currentToken().content) {
                    case "lasteventtime": {
                        this.parseArguments(parser);
                    }
                }
            } else {
                if (!nextToken.checkType(91)) {
                    throw new UnexpectedTokenException("[", parser.currentToken());
                }
                if (!parser.nextToken().checkType(3)) {
                    throw new UnexpectedTokenException("NUMBER", parser.currentToken());
                }
                ValueNode valueNode = (ValueNode)parser.getObject();
                this._channel = (Integer)valueNode.Value;
                if (!parser.nextToken().checkType(93)) {
                    throw new UnexpectedTokenException("[]", parser.currentToken());
                }
                if (!parser.nextToken().checkType(46)) {
                    throw new UnexpectedTokenException(".", parser.currentToken());
                }
                if (!parser.nextToken().checkType(0)) {
                    throw new UnexpectedTokenException("FIELD NAME", parser.currentToken());
                }
                this._fieldOrMethodName = parser.currentToken().content;
            }
        }
        catch (Exception ex) {
            throw new ScriptParserException("unable to process relay output");
        }
        return this;
    }

    @Override
    public Object execute(Scope scope) {
        if (-1 == this._channel) {
            if ("lasteventtime".equalsIgnoreCase(this._fieldOrMethodName)) {
                INPUT_IO_LOG.refresh();
                IoEvent[] outputEvents = INPUT_IO_LOG.getOutputEvents(1);
                IoEvent lastOutputEvent = outputEvents[0];
                System.out.println("lastOutputEvent = " + new Date(lastOutputEvent.timestamp));
                return lastOutputEvent.timestamp;
            }
        } else {
            return RelayOutputObject.read(this._channel, this._fieldOrMethodName);
        }
        return null;
    }

    public static Object read(int channel, String fieldOrMethodName) {
        if ("state".equalsIgnoreCase(fieldOrMethodName)) {
            return 0 != (JANOS.getOutputStates() >> channel - 1 & 1);
        }
        if ("usagemeter".equalsIgnoreCase(fieldOrMethodName)) {
            return JANOS.getUsageMeter((int)(UnitConfig.getInputCount() + channel - 1));
        }
        throw new RuntimeException(String.format("unknown field or method: %s", fieldOrMethodName));
    }
}

