class DeviceObject extends TaskerObject {
    constructor(name) {
        super();
        this.Name = name; // || 'new Device';
    }


    editTemplate() {
        var template = 'editTemplate() not overridden';
        return template;
    }
}



class EthernetDevice extends DeviceObject {
    constructor(name, ipAddress, port) {
        super(name);
        this.Type = 'EthernetDevice';
        this.Params = {};
    }


    editTemplate() {
        var template = 'IP Address <input type="text" class="form-control" ng-model="device.Params.IpAddress" ' +
            '  style="width:150px;" name="ip-address-' + guid() + '" required> ' +
            ' TCP Port <input type="number" class="form-control" ng-model="device.Params.Port" ' +
            '  style="width:100px;" name="port-' + guid() + '" required>';
        return template;
    }
}



class SNMPDevice extends DeviceObject {
    constructor(name) {
        super(name);
        this.Type = 'SNMPDevice';
        this.Params = { Port: 162, CommunityName: 'public' };
    }


    editTemplate() {
        var template = 'IP Address <input type="text" class="form-control" ng-model="device.Params.IpAddress" ' +
            '  style="width:150px;" name="ip-address-' + guid() + '" required> ' +
            ' UDP Port <input type="number" class="form-control" ng-model="device.Params.Port" ' +
            '  style="width:100px;" name="port-' + guid() + '" required>' +
            ' Community Name <input type="text" class="form-control" ng-model="device.Params.CommunityName" ' +
            '  style="width:200px;" name="community-name-' + guid() + '" required>';
        return template;
    }
}



class ProjectorDevice extends DeviceObject {
    constructor(name) {
        super(name);
        this.Type = 'ProjectorDevice';
    }


    editTemplate() {
        var template = '<div>\r\n' +
            '<b>Projector:</b> Type <select class="form-control" ng-model="device.Params.ProjectorType"' +
            '  ng-options="device.Type as device.Name for device in controller.getProjectorDevices()">\r\n' +
            ' </select>\r\n' +
            ' <select class="form-control" ng-model="device.Params.CommType" ng-show="deviceType.EthernetDefaults && deviceType.SerialDefaults">\r\n' +
            '   <option value="">Ethernet</option>\r\n' +
            '   <option value="serial">Serial</option>\r\n' +
            ' </select>\r\n' +
            '<span ng-show="deviceType.EthernetDefaults && (!deviceType.SerialDefaults || !device.Params.CommType || ((undefined != device.Params.CommType) && (\'\' == device.Params.CommType)))">\r\n' +
            ' IP Address <input type="text" class="form-control" ng-model="device.Params.IpAddress" \r\n' +
            '  style="width:125px;" name="ip-address-' + guid() + '" required>\r\n' +
            ' TCP Port <input type="number" class="form-control" ng-model="device.Params.Port" \r\n' +
            '  style="width:100px;" name="port-' + guid() + '" placeholder="{{deviceType.EthernetDefaults.DefaultPort}}">\r\n' +
            ' <span ng-if="device.Params.ProjectorType.startsWith(\'barco\')">\r\n' +
            '  Username <input type="text" class="form-control" ng-model="device.Params.Username" \r\n' +
            '   style="width:100px;" name="username-' + guid() + '" required>\r\n' +
            '  Password <input type="password" class="form-control" ng-model="device.Params.Password" \r\n' +
            '   style="width:100px;" name="password-' + guid() + '" required>\r\n' +
            ' </span>' +
            '</span>' +
            '<span ng-show="deviceType.SerialDefaults && (!deviceType.EthernetDefaults || ((undefined != device.Params.CommType) && (\'serial\' == device.Params.CommType)))">\r\n' +
            ' Baud Rate <select class="form-control" ng-model="device.Params.BaudRate">\r\n' +
            '   <option value="" disabled selected>{{deviceType.SerialDefaults.BaudRate}}</option>\r\n' +
            '   <option>9600</option>\r\n' +
            '   <option>115200</option>\r\n' +
            ' </select>\r\n' +
            ' Data Bits <select class="form-control" ng-model="device.Params.DataBits">\r\n' +
            '   <option value="" disabled selected>{{deviceType.SerialDefaults.DataBits}}</option>\r\n' +
            '   <option>7</option>\r\n' +
            '   <option>8</option>\r\n' +
            ' </select>\r\n' +
            ' Stop Bits <select class="form-control" ng-model="device.Params.StopBits">\r\n' +
            '   <option value="" disabled selected>1</option>\r\n' +
            '   <option>1</option>\r\n' +
            '   <option>1.5</option>\r\n' +
            '   <option>2</option>\r\n' +
            ' </select>\r\n' +
            ' Parity <select class="form-control" ng-model="device.Params.Parity">\r\n' +
            '   <option value="" selected>None</option>\r\n' +
            '   <option>Even</option>\r\n' +
            '   <option>Odd</option>\r\n' +
            ' </select>\r\n' +
            '</span></div>';
        return template;
        // var template = '<b>Projector:</b> Type <select class="form-control" ng-model="device.Params.ProjectorType"' +
        //     '  ng-options="device.Type as device.Name for device in controller.getProjectorDevices()">\r\n' +
        //     ' </select>\r\n' +
        //     ' <select class="form-control" ng-model="device.Params.CommType">\r\n' +
        //     '   <option value="">Ethernet</option>\r\n' +
        //     '   <option value="serial">Serial</option>\r\n' +
        //     ' </select>\r\n' +
        //     '<span ng-if="\"serial\" != device.Params.CommType">\r\n' +
        //     ' IP Address <input type="text" class="form-control" ng-model="device.Params.IpAddress" \r\n' +
        //     '  style="width:150px;" name="ip-address-' + guid() + '" required>\r\n' +
        //     ' TCP Port <input type="number" class="form-control" ng-model="device.Params.Port" \r\n' +
        //     '  style="width:100px;" name="port-' + guid() + '" placeholder="{{controller.getProjectorForType(device.Params.ProjectorType).DefaultPort}}">\r\n' +
        //     ' <span ng-if="controller.getProjectorForType(device.Params.ProjectorType).PasswordReqired">\r\n' +
        //     '   Username <input type="text" class="form-control" ng-model="device.Params.Username" \r\n' +
        //     '     style="width:100px;" name="username-' + guid() + '" required>\r\n' +
        //     '   Password <input type="password" class="form-control" ng-model="device.Params.Password" \r\n' +
        //     '     style="width:100px;" name="password-' + guid() + '" required>\r\n' +
        //     ' </span>' +
        //     '</span>' +
        //     '<span ng-if="\"serial\" == device.Params.CommType">\r\n' +
        //     ' Baud Rate <input type="text" class="form-control" ng-model="device.Params.IpAddress" \r\n' +
        //     '  style="width:150px;" name="ip-address-' + guid() + '" required>\r\n' +
        //     ' TCP Port <input type="number" class="form-control" ng-model="device.Params.Port" \r\n' +
        //     '  style="width:100px;" name="port-' + guid() + '" placeholder="{{controller.getProjectorForType(device.Params.ProjectorType).DefaultPort}}">\r\n' +
        //     ' <span ng-if="controller.getProjectorForType(device.Params.ProjectorType).PasswordReqired">\r\n' +
        //     '   Username <input type="text" class="form-control" ng-model="device.Params.Username" \r\n' +
        //     '     style="width:100px;" name="username-' + guid() + '" required>\r\n' +
        //     '   Password <input type="password" class="form-control" ng-model="device.Params.Password" \r\n' +
        //     '     style="width:100px;" name="password-' + guid() + '" required>\r\n' +
        //     ' </span>' +
        //     '</span>';
        // return template;
    }
}



class SoundProcessorDevice extends DeviceObject {
    constructor(name) {
        super(name);
        this.Type = 'SoundProcessorDevice';
    }


    editTemplate() {
        var template = '<div>\r\n' +
            '<b>Sound Processor:</b> Type <select class="form-control" ng-model="device.Params.SoundProcessorType"' +
            '  ng-options="device.Type as device.Name for device in controller.getSoundProcessorDevices()">\r\n' +
            ' </select>\r\n' +
            ' <select class="form-control" ng-model="device.Params.CommType" ng-show="deviceType.EthernetDefaults && deviceType.SerialDefaults">\r\n' +
            '   <option value="">Ethernet</option>\r\n' +
            '   <option value="serial">Serial</option>\r\n' +
            ' </select>\r\n' +
            '<span ng-show="deviceType.EthernetDefaults && (!deviceType.SerialDefaults || !device.Params.CommType || ((undefined != device.Params.CommType) && (\'\' == device.Params.CommType)))">\r\n' +
            ' IP Address <input type="text" class="form-control" ng-model="device.Params.IpAddress" \r\n' +
            '  style="width:125px;" name="ip-address-' + guid() + '" required>\r\n' +
            ' TCP Port <input type="number" class="form-control" ng-model="device.Params.Port" \r\n' +
            '  style="width:100px;" name="port-' + guid() + '" placeholder="{{deviceType.EthernetDefaults.DefaultPort}}">\r\n' +
            ' <span ng-if="device.Params.ProjectorType.startsWith(\'barco\')">\r\n' +
            '  Username <input type="text" class="form-control" ng-model="device.Params.Username" \r\n' +
            '   style="width:100px;" name="username-' + guid() + '" required>\r\n' +
            '  Password <input type="password" class="form-control" ng-model="device.Params.Password" \r\n' +
            '   style="width:100px;" name="password-' + guid() + '" required>\r\n' +
            ' </span>' +
            '</span>' +
            '<span ng-show="deviceType.SerialDefaults && (!deviceType.EthernetDefaults || ((undefined != device.Params.CommType) && (\'serial\' == device.Params.CommType)))">\r\n' +
            ' Baud Rate <select class="form-control" ng-model="device.Params.BaudRate">\r\n' +
            '   <option value="" disabled selected>{{deviceType.SerialDefaults.BaudRate}}</option>\r\n' +
            '   <option>9600</option>\r\n' +
            '   <option>115200</option>\r\n' +
            ' </select>\r\n' +
            ' Data Bits <select class="form-control" ng-model="device.Params.DataBits">\r\n' +
            '   <option value="" disabled selected>{{deviceType.SerialDefaults.DataBits}}</option>\r\n' +
            '   <option>7</option>\r\n' +
            '   <option>8</option>\r\n' +
            ' </select>\r\n' +
            ' Stop Bits <select class="form-control" ng-model="device.Params.StopBits">\r\n' +
            '   <option value="" disabled selected>1</option>\r\n' +
            '   <option>1</option>\r\n' +
            '   <option>1.5</option>\r\n' +
            '   <option>2</option>\r\n' +
            ' </select>\r\n' +
            ' Parity <select class="form-control" ng-model="device.Params.Parity">\r\n' +
            '   <option value="" selected>None</option>\r\n' +
            '   <option>Even</option>\r\n' +
            '   <option>Odd</option>\r\n' +
            ' </select>\r\n' +
            '</span></div>';
        return template;
    }
}



class ModbusDevice extends DeviceObject {
    constructor(name) {
        super(name);
        this.Type = 'ModbusDevice';
        this.Params = { Port: 502 };
    }


    editTemplate() {
        var template = 'IP Address <input type="text" class="form-control" ng-model="device.Params.IpAddress" ' +
            '  style="width:150px;" name="ip-address-' + guid() + '" required> ' +
            ' TCP Port <input type="number" class="form-control" ng-model="device.Params.Port" ' +
            '  style="width:100px;" name="port-' + guid() + '" required>'
        return template;
    }
}