/*
 * Decompiled with CFR 0.152.
 */
package com.integ.tasker.devices;

import com.integpg.janoslib.logger.FileLog;
import com.integpg.janoslib.logger.LogOptions;
import com.integpg.janoslib.logger.Logger;
import com.integpg.janoslib.system.Application;
import java.io.IOException;
import java.io.InputStream;

public class IncomingSocketReader
implements Runnable {
    public static final Logger LOG = FileLog.getHalfBackupLog(new LogOptions(Application.getAppName() + "_devices.log"));
    private final String _name;
    private final InputStream _inputStream;
    private Thread _thread = null;

    public IncomingSocketReader(String name, InputStream inputStream) {
        this._name = name;
        this._inputStream = inputStream;
    }

    public void start() {
        this._thread = new Thread(this);
        this._thread.setName(IncomingSocketReader.class.getName() + ":" + this._name);
        this._thread.start();
    }

    @Override
    public void run() {
        byte[] buffer = new byte[1024];
        try {
            while (true) {
                int bytesRead = this._inputStream.read(buffer);
                System.out.println(String.format("%d bytes read from %s incoming socket reader", bytesRead, this._name));
            }
        }
        catch (IOException ex) {
            LOG.error(String.format("error reading from %s", this._name), ex);
            return;
        }
    }
}

