/*
 * Decompiled with CFR 0.152.
 */
package com.integ.tasker.schedules.rules.sunequation;

public class SunEquations {
    private double _sunRise = Double.NaN;
    private double _sunSet = Double.NaN;

    public double getSunrise() {
        return this._sunRise;
    }

    public double getSunset() {
        return this._sunSet;
    }

    public void calculate(int daysPastJan1, double latitude, double longitude) {
        latitude = Math.abs(latitude);
        longitude = Math.abs(longitude);
        double J = 2451545.0009 + longitude / 360.0 + (double)daysPastJan1;
        double M = (357.5291 + 0.98560028 * (J - 2451545.0)) % 360.0;
        double C = 1.9148 * Math.sin(this.getRadiansFromDegrees(M)) + 0.02 * Math.sin(this.getRadiansFromDegrees(2.0 * M)) + 3.0E-4 * Math.sin(this.getRadiansFromDegrees(3.0 * M));
        double \u03bb = (M + 102.9372 + C + 180.0) % 360.0;
        double jTransit = J + 0.0053 * Math.sin(this.getRadiansFromDegrees(M)) - 0.0069 * Math.sin(this.getRadiansFromDegrees(2.0 * \u03bb));
        double newM = 0.0;
        double newC = 0.0;
        double new\u03bb = 0.0;
        for (int i = 0; i < 3; ++i) {
            newM = (357.5291 + 0.98560028 * (jTransit - 2451545.0)) % 360.0;
            newC = 1.9148 * Math.sin(this.getRadiansFromDegrees(newM)) + 0.02 * Math.sin(this.getRadiansFromDegrees(2.0 * newM)) + 3.0E-4 * Math.sin(this.getRadiansFromDegrees(3.0 * newM));
            new\u03bb = (newM + 102.9372 + newC + 180.0) % 360.0;
        }
        double \u03b4 = this.getDegreesFromRadians(Math.asin(Math.sin(this.getRadiansFromDegrees(new\u03bb)) * Math.sin(this.getRadiansFromDegrees(23.45))));
        double H = this.getDegreesFromRadians(Math.acos((Math.sin(this.getRadiansFromDegrees(-0.83)) - Math.sin(this.getRadiansFromDegrees(latitude)) * Math.sin(this.getRadiansFromDegrees(\u03b4))) / (Math.cos(this.getRadiansFromDegrees(latitude)) * Math.cos(this.getRadiansFromDegrees(\u03b4)))));
        double JJ = 2451545.0009 + (H + longitude) / 360.0 + (double)daysPastJan1;
        this._sunSet = JJ + (0.0053 * Math.sin(this.getRadiansFromDegrees(newM)) - 0.0069 * Math.sin(this.getRadiansFromDegrees(2.0 * new\u03bb)));
        this._sunRise = jTransit - (this._sunSet - jTransit);
    }

    private double getRadiansFromDegrees(double angdeg) {
        return angdeg / 180.0 * Math.PI;
    }

    private double getDegreesFromRadians(double angrad) {
        return angrad * 180.0 / Math.PI;
    }
}

