/*
 * Decompiled with CFR 0.152.
 */
package com.integ.tasker.triggers;

import com.integ.janoslib.messagepump.MessagePumpEngine;
import com.integ.tasker.WorkspaceConfigurationFile;
import com.integ.tasker.signals.SignalProfile;
import com.integ.tasker.signals.SignalProfilesCollection;
import com.integ.tasker.tasks.Task;
import com.integ.tasker.tasks.TaskCollection;
import com.integ.tasker.triggers.AnalogReset;
import com.integ.tasker.triggers.AnalogTrigger;
import com.integ.tasker.triggers.DiscreteReset;
import com.integ.tasker.triggers.DiscreteTrigger;
import com.integ.tasker.triggers.Reset;
import com.integ.tasker.triggers.Trigger;
import com.integ.tasker.triggers.TriggerConfiguration;
import com.integ.tasker.triggers.TriggerListener;
import com.integ.tasker.triggers.TriggerMonitorCollection;
import com.integ.tasker.triggers.TriggerObject;
import com.integ.tasker.web.handlers.ErrorMessage;
import com.integpg.janoslib.io.AppLog;
import java.util.Json;

public class TriggerMonitor
implements Runnable,
TriggerListener {
    private final WorkspaceConfigurationFile _workspaceConfigurationFile;
    private String _name;
    private boolean _enabled = false;
    private Trigger _trigger;
    private Json _triggerSignalJson;
    private SignalProfile _triggerSignalProfile;
    private Reset _reset;
    private Json _resetSignalJson;
    private SignalProfile _resetSignalProfile;
    private boolean _triggered;
    private String _taskName;
    private Thread _thread;
    private boolean _initial = true;
    private boolean _cancelled = false;

    public TriggerMonitor(Json signalJson, WorkspaceConfigurationFile workspaceConfigurationFile) {
        this._workspaceConfigurationFile = workspaceConfigurationFile;
        this.updateConfig(signalJson);
    }

    public String getName() {
        return this._name;
    }

    public final void updateConfig(Json signalJson) {
        long start = System.currentTimeMillis();
        this._name = signalJson.getString("Name");
        Json paramsJson = (Json)signalJson.get("Params");
        if (null != paramsJson.get("Enabled")) {
            this._enabled = (Boolean)paramsJson.get("Enabled");
            System.out.println("_enabled: " + this._enabled);
            if (!this._enabled) {
                return;
            }
        }
        this._taskName = paramsJson.getString("TaskName");
        System.out.println("_taskName: " + this._taskName);
        Json triggerJson = (Json)paramsJson.get("Trigger");
        if (null != triggerJson) {
            SignalProfilesCollection signalProfilesCollection = this._workspaceConfigurationFile.getSignalProfilesCollection();
            this._triggerSignalJson = (Json)triggerJson.get("Signal");
            String triggerSignalProfileString = this._triggerSignalJson.getString("Name");
            if (signalProfilesCollection.containsSignalProfileName(triggerSignalProfileString)) {
                this._triggerSignalProfile = signalProfilesCollection.getByName(triggerSignalProfileString);
                Trigger trigger = null;
                if (null != triggerJson.get("Value")) {
                    trigger = new AnalogTrigger(this._triggerSignalProfile, triggerJson);
                } else if (null != triggerJson.get("State")) {
                    trigger = new DiscreteTrigger(this._triggerSignalProfile, triggerJson, this._taskName);
                    trigger.addTriggerListener(this);
                }
                if (null == trigger) {
                    this._enabled = false;
                }
                this._trigger = trigger;
                System.out.println("_trigger: " + this._trigger);
            } else {
                this._enabled = false;
            }
            Json resetJson = (Json)paramsJson.get("Reset");
            if (null != resetJson) {
                this._resetSignalJson = (Json)resetJson.get("Signal");
                String resetSignalProfileString = this._resetSignalJson.getString("Name");
                if (signalProfilesCollection.containsSignalProfileName(resetSignalProfileString)) {
                    this._resetSignalProfile = signalProfilesCollection.getByName(resetSignalProfileString);
                    Reset reset = null;
                    if (null != resetJson.get("Value")) {
                        reset = new AnalogReset(this._resetSignalProfile, resetJson);
                    } else if (null != resetJson.get("State")) {
                        reset = new DiscreteReset(this._resetSignalProfile, resetJson);
                    }
                    this._reset = reset;
                    System.out.println("_reset: " + this._reset);
                }
            } else if (this._trigger instanceof AnalogTrigger) {
                this._reset = new AnalogReset(this._triggerSignalProfile, triggerJson);
                this._reset.makeReset();
            } else if (this._trigger instanceof DiscreteTrigger) {
                this._reset = new DiscreteReset(this._triggerSignalProfile, triggerJson);
                this._reset.makeReset();
            }
            if (this._enabled) {
                TriggerMonitorCollection.add(this);
            }
        } else {
            this._enabled = false;
        }
        long elapsed = System.currentTimeMillis() - start;
        System.out.println("\r\n\r\nLOADING TOOK: " + elapsed + "\r\n\r\n");
    }

    public void start() {
        if (this._enabled && null == this._thread) {
            this._cancelled = false;
            this._thread = new Thread(this);
            this._thread.setDaemon(true);
            this._thread.setName(this.getClass().getName() + ":" + this._name);
            this._thread.start();
        }
    }

    void stop() {
        try {
            TriggerConfiguration.LOG.info("Stopping " + this._name);
            this._cancelled = true;
            this._thread.interrupt();
            this._thread.join();
            this._trigger.detachListeners();
            this._reset.detachListeners();
        }
        catch (Exception e) {
            System.out.println("Exception handled: " + e.getMessage());
        }
    }

    @Override
    public void run() {
        TriggerConfiguration.LOG.info(this._name + " started.");
        while (!this._cancelled) {
            try {
                this.checkMonitor();
                Thread.sleep(200L);
            }
            catch (InterruptedException ex) {
                System.out.println(this._name + " interrupted");
                break;
            }
        }
        TriggerConfiguration.LOG.info(this._name + " done.");
        this._thread = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkMonitor() {
        Thread thread = this._thread;
        synchronized (thread) {
            try {
                if (!this._triggered) {
                    this._triggered = this._trigger.checkForTrigger();
                    if (this._triggered && !this._initial) {
                        AppLog.info(this._name + " checkMonitor TRIGGERED!");
                        if (this._enabled) {
                            new Thread(new Runnable(){

                                @Override
                                public void run() {
                                    try {
                                        Task task = TaskCollection.GLOBAL.getByTaskName(TriggerMonitor.this._taskName);
                                        if (null != task) {
                                            task.execute();
                                        }
                                    }
                                    catch (Throwable ex) {
                                        Throwable throwable = new Exception("error executing task by name: " + TriggerMonitor.this._taskName).initCause(ex);
                                        TriggerConfiguration.LOG.error(throwable);
                                        ErrorMessage message = new ErrorMessage(throwable);
                                        MessagePumpEngine.postMessage(message.build());
                                    }
                                }
                            }).start();
                        }
                    }
                } else {
                    boolean bl = this._triggered = !this._reset.checkForReset();
                    if (!this._triggered && !this._initial) {
                        TriggerConfiguration.LOG.info(this._name + " RESET!");
                    }
                    this._reset.clearReset();
                }
                this._initial = false;
            }
            catch (Throwable ex) {
                TriggerConfiguration.LOG.error(ex);
            }
        }
    }

    @Override
    public void onTrigger(TriggerObject source) {
        TriggerConfiguration.LOG.info(this._name + " onTrigger TRIGGERED!");
        if (this._enabled) {
            this.checkMonitor();
        }
    }

    private static enum SIGNAL_TYPE {
        DISCRETE,
        ANALOG;

    }
}

