/*
 * Decompiled with CFR 0.152.
 */
package com.integ.tasker.tasks;

import com.integ.tasker.tasks.Task;
import java.util.Enumeration;
import java.util.Hashtable;

public class TaskCollection {
    public static final TaskCollection GLOBAL = new TaskCollection();
    private final Hashtable<String, Task> _collection = new Hashtable();

    public Hashtable<String, Task> getTasks() {
        return this._collection.clone();
    }

    public void clear() {
        if (this == GLOBAL) {
            return;
        }
        Enumeration<String> e = this._collection.keys();
        while (e.hasMoreElements()) {
            String taskName = e.nextElement();
            this._collection.remove(taskName);
            TaskCollection.GLOBAL._collection.remove(taskName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(Task task) {
        if (this == GLOBAL) {
            return;
        }
        Hashtable<String, Task> hashtable = this._collection;
        synchronized (hashtable) {
            this._collection.put(task.Name.toLowerCase(), task);
            TaskCollection.GLOBAL._collection.put(task.Name.toLowerCase(), task);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsTaskName(String taskName) {
        Hashtable<String, Task> hashtable = this._collection;
        synchronized (hashtable) {
            taskName = taskName.toLowerCase();
            return this._collection.containsKey(taskName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Task getByTaskName(String taskName) {
        Hashtable<String, Task> hashtable = this._collection;
        synchronized (hashtable) {
            taskName = taskName.toLowerCase();
            if (!this._collection.containsKey(taskName)) {
                throw new RuntimeException(String.format("%s task is not found", taskName));
            }
            return this._collection.get(taskName);
        }
    }
}

