/*
 * Decompiled with CFR 0.152.
 */
package com.integ.tasker;

import com.integ.janoslib.iolog.DigitalInputsIoLogMonitor;
import com.integ.janoslib.iolog.DigitalOutputsIoLogMonitor;
import com.integ.janoslib.messagepump.MessagePumpAppHandler;
import com.integ.janoslib.messagepump.MessagePumpEngine;
import com.integ.tasker.AssemblyInfo;
import com.integ.tasker.Config;
import com.integ.tasker.ConfigurationFileMonitor;
import com.integ.tasker.WorkspaceDirectory;
import com.integ.tasker.schedules.ScheduleMonitor;
import com.integ.tasker.triggers.DigitalInputMonitor;
import com.integ.tasker.triggers.DigitalOutputMonitor;
import com.integ.tasker.webhandlers.AnnounceHandler;
import com.integ.tasker.webhandlers.AnnounceMessage;
import com.integ.tasker.webhandlers.ConfigurationUpdatedHandler;
import com.integ.tasker.webhandlers.TaskExecuteHandler;
import com.integpg.janoslib.externalio.controlpanel.ControlPanel;
import com.integpg.janoslib.externalio.controlpanel.ControlPanelListener;
import com.integpg.janoslib.io.AppLog;
import com.integpg.janoslib.system.Application;
import com.integpg.janoslib.system.ApplicationWatchdog;
import com.integpg.system.JANOS;

public class TaskerMain {
    public static final TaskerMain INSTANCE = new TaskerMain();
    public static final DigitalInputsIoLogMonitor DIGITAL_INPUTS_IO_LOG_MONITOR = new DigitalInputsIoLogMonitor();
    public static final DigitalInputMonitor DIGITAL_INPUT_MONITOR = new DigitalInputMonitor();
    public static final DigitalOutputsIoLogMonitor DIGITAL_OUTPUTS_IO_LOG_MONITOR = new DigitalOutputsIoLogMonitor();
    public static final DigitalOutputMonitor DIGITAL_OUTPUT_MONITOR = new DigitalOutputMonitor();
    private static final ApplicationWatchdog APPLICATION_WATCHDOG = new ApplicationWatchdog(0);
    private ControlPanel _controlPanel;

    public static void main(String[] args) throws InterruptedException {
        Application.init(new AssemblyInfo());
        INSTANCE.init();
        AnnounceMessage announceMessage = new AnnounceMessage();
        while (true) {
            try {
                while (true) {
                    MessagePumpEngine.postMessage(announceMessage.build());
                    Thread.sleep(10000L);
                    APPLICATION_WATCHDOG.feed();
                }
            }
            catch (Exception ex) {
                AppLog.error(ex);
                continue;
            }
            break;
        }
    }

    public static ControlPanel getControlPanel() {
        return TaskerMain.INSTANCE._controlPanel;
    }

    private void init() throws InterruptedException {
        Config.initializeDirectories();
        DIGITAL_INPUTS_IO_LOG_MONITOR.addIoChannelLogEventListener(DIGITAL_INPUT_MONITOR);
        DIGITAL_INPUTS_IO_LOG_MONITOR.start();
        DIGITAL_OUTPUTS_IO_LOG_MONITOR.addIoChannelLogEventListener(DIGITAL_OUTPUT_MONITOR);
        DIGITAL_OUTPUTS_IO_LOG_MONITOR.start();
        AppLog.info("add web page listener");
        MessagePumpAppHandler appListener = new MessagePumpAppHandler(2010).addCommandListener("announce.request", new AnnounceHandler()).addCommandListener("task.execute", new TaskExecuteHandler()).addCommandListener("config.updated", new ConfigurationUpdatedHandler());
        MessagePumpEngine.addListener(appListener);
        MessagePumpEngine.start();
        this.initControlPanel();
        WorkspaceDirectory workspaceDirectory = new WorkspaceDirectory(Config.TaskerWorkspacesDirectory);
        workspaceDirectory.monitorWorkspaceDirectory();
        ConfigurationFileMonitor.start();
        ScheduleMonitor.start();
    }

    private void initControlPanel() {
        System.out.println("init control panel");
        this._controlPanel = new ControlPanel();
        this._controlPanel.addListener(new ControlPanelListener(){

            @Override
            public boolean switchesPressed(Object source, int channelMask) {
                System.out.println(String.format("switches pressed: %2x", channelMask));
                return true;
            }

            @Override
            public boolean switchPressed(Object source, int channel, int count) {
                System.out.println(String.format("switch pressed: %d, %d time(s)", channel, count));
                return true;
            }
        });
        this._controlPanel.monitorSwitches(250);
    }

    protected void finalize() {
        JANOS.syslog((String)"Tasker exiting...");
    }
}

