/*
 * Decompiled with CFR 0.152.
 */
package com.integ.tasker.tasks;

import com.integ.janoslib.messagepump.MessagePumpEngine;
import com.integ.tasker.tasks.RunningTaskCollection;
import com.integ.tasker.tasks.TaskCollection;
import com.integ.tasker.tasks.TaskConfiguration;
import com.integ.tasker.tasks.TaskResult;
import com.integ.tasker.tasks.TaskRuntime;
import com.integ.tasker.tasks.actions.Action;
import com.integ.tasker.tasks.actions.ActionFactory;
import com.integ.tasker.triggers.TriggersConfiguration;
import com.integ.tasker.web.messages.ErrorMessage;
import java.util.Json;

public class Task {
    public String Name;
    public String FullName;
    private final TaskConfiguration _taskConfiguration;
    private final String _parentWorkspaceName;
    private boolean _enabled;
    private Action _baseAction;

    public Task(TaskConfiguration taskConfiguration, String parentWorkspaceName) {
        this._taskConfiguration = taskConfiguration;
        this._parentWorkspaceName = parentWorkspaceName;
    }

    public TaskConfiguration getTaskConfiguration() {
        return this._taskConfiguration;
    }

    public void load(Json taskJson) {
        try {
            Action baseAction;
            this.Name = taskJson.getString("Name");
            this.FullName = String.format("%s::%s", this._taskConfiguration.getWorkspaceConfigurationFile().getName(), this.Name);
            TaskConfiguration.LOG.info(String.format("loading task \"%s\"", this.FullName));
            this._enabled = taskJson.getBoolean("Enabled");
            if (!this._enabled) {
                TaskConfiguration.LOG.info(this.FullName + " is not enabled");
            }
            Json baseActionJson = (Json)taskJson.get("Action");
            this._baseAction = baseAction = ActionFactory.getActionClass(this, baseActionJson);
        }
        catch (Throwable ex) {
            Throwable throwable = new Exception("unable to load " + this.Name).initCause(ex);
            TaskConfiguration.LOG.error(throwable);
            ErrorMessage message = new ErrorMessage(throwable);
            MessagePumpEngine.postMessage(message.build());
        }
    }

    public String getParentWorkspaceName() {
        return this._parentWorkspaceName;
    }

    public void cleanup() {
    }

    public static void executeByName(final String taskName) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    Task task = TaskCollection.GLOBAL.getByTaskName(taskName);
                    if (null != task) {
                        task.execute();
                    }
                }
                catch (Throwable ex) {
                    Exception throwable = new Exception("error executing task '" + taskName + "' by name", ex);
                    TriggersConfiguration.LOG.error(throwable);
                    ErrorMessage message = new ErrorMessage(throwable);
                    MessagePumpEngine.postMessage(message.build());
                }
            }
        }).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TaskResult execute() throws Throwable {
        long startTime = System.currentTimeMillis();
        TaskResult result = TaskResult.SUCCESS;
        if (this._enabled) {
            TaskRuntime taskRuntime = new TaskRuntime(this);
            RunningTaskCollection.registerTask(taskRuntime);
            try {
                if (null == this._baseAction) {
                    throw new RuntimeException(String.format("Base action is null for %s", this.FullName));
                }
                TaskConfiguration.LOG.info(String.format("execute %s", this.FullName));
                this._baseAction.execute(taskRuntime);
                long elapsed = System.currentTimeMillis() - startTime;
                TaskConfiguration.LOG.info(String.format("%s has executed in %.2f seconds", this.FullName, (double)elapsed / 1000.0));
            }
            catch (Throwable ex) {
                if (!taskRuntime.Cancelled) {
                    result = TaskResult.FAILED;
                    throw new Exception(String.format("error executing task \"%s\" in workspace \"%s\"", this.Name, this._taskConfiguration.getWorkspaceConfigurationFile().getName())).initCause(ex);
                }
                result = TaskResult.CANCELLED;
            }
            finally {
                RunningTaskCollection.unregisterTask(taskRuntime);
            }
        }
        return result;
    }
}

