/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.tasker.ast;

import com.integpg.janoslib.lexer.Token;
import com.integpg.tasker.ast.ASTNode;
import com.integpg.tasker.ast.ASTParser;

public class ASTBinaryNode
implements ASTNode {
    private final Token _operator;
    private final ASTNode _left;
    private final ASTNode _right;

    public ASTBinaryNode(Token operator, ASTNode left, ASTNode right) {
        this._operator = operator;
        this._left = left;
        this._right = right;
    }

    @Override
    public Number evaluate() {
        if (ASTParser.isDebug()) {
            System.out.println("ASTBinaryNode: " + this);
        }
        try {
            Object left = this._left.evaluate();
            Object right = this._right.evaluate();
            if (!(left instanceof Number) || !(right instanceof Number)) {
                return 0;
            }
            Number leftNumber = (Number)left;
            Number rightNumber = (Number)right;
            switch (this._operator.type) {
                case 43: {
                    if (left instanceof Integer && right instanceof Integer) {
                        return leftNumber.intValue() + rightNumber.intValue();
                    }
                    if (left instanceof Double && right instanceof Integer) {
                        return leftNumber.doubleValue() + (double)rightNumber.intValue();
                    }
                    if (left instanceof Integer && right instanceof Double) {
                        return (double)leftNumber.intValue() + rightNumber.doubleValue();
                    }
                    return leftNumber.doubleValue() + rightNumber.doubleValue();
                }
                case 45: {
                    if (leftNumber instanceof Integer && right instanceof Integer) {
                        return leftNumber.intValue() - rightNumber.intValue();
                    }
                    return leftNumber.doubleValue() - rightNumber.doubleValue();
                }
                case 42: {
                    if (left instanceof Integer && right instanceof Integer) {
                        return leftNumber.intValue() * rightNumber.intValue();
                    }
                    if (left instanceof Double && right instanceof Integer) {
                        return leftNumber.doubleValue() * (double)rightNumber.intValue();
                    }
                    if (left instanceof Integer && right instanceof Double) {
                        return (double)leftNumber.intValue() * rightNumber.doubleValue();
                    }
                    return leftNumber.doubleValue() * rightNumber.doubleValue();
                }
                case 47: {
                    return leftNumber.doubleValue() / rightNumber.doubleValue();
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.out.println("Left: " + this._left);
            System.out.println("Right: " + this._right);
        }
        return Double.NaN;
    }

    public String toString() {
        String retString = "(";
        retString = retString + this._left;
        retString = retString + " " + this._operator.content + " ";
        retString = retString + this._right;
        retString = retString + ")";
        return retString;
    }
}

