/*
 * Decompiled with CFR 0.152.
 */
package com.integ.tasker.tasks.actions.other;

import com.integ.tasker.TextReplacer;
import com.integ.tasker.tasks.Task;
import com.integ.tasker.tasks.TaskRuntime;
import com.integ.tasker.tasks.actions.Action;
import com.integ.tasker.web.messages.ErrorMessage;
import com.integpg.janoslib.logging.AppLog;
import com.integpg.janoslib.utils.FileUtils;
import com.integpg.janoslib.utils.StringUtils;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.Json;

public class FilePrependMethod
extends Action {
    private final String _filename;

    public FilePrependMethod(Task parentTask, Json json) {
        super(parentTask, json);
        this._filename = this._paramsJson.getString("Filename");
    }

    @Override
    public void execute(TaskRuntime taskRuntime) throws Throwable {
        boolean _debug_ = taskRuntime.Scope.isDebug();
        try {
            String text = this._paramsJson.getString("Text");
            text = text.trim();
            if (_debug_) {
                System.out.println("text: " + text);
            }
            text = TextReplacer.replace(text, taskRuntime.Scope);
            if (_debug_) {
                System.out.println("text: " + text);
            }
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            out.write(StringUtils.getEscapedBytes(text));
            File file = new File(this._filename);
            if (file.exists()) {
                out.write(FileUtils.readAllBytes(this._filename));
            }
            FileUtils.writeAllBytes(this._filename, out.toByteArray());
        }
        catch (Throwable ex) {
            AppLog.error(ex);
            new ErrorMessage(ex).postMessage();
            throw new IOException("Error prepending to: " + this._filename).initCause(ex);
        }
    }
}

