/*
 * Decompiled with CFR 0.152.
 */
package com.integ.tasker.triggers.triggertypes;

import com.integ.scripting.exceptions.DeviceNotPresentException;
import com.integ.scripting.objects.EnvironObject;
import com.integ.scripting.objects.FourTwentyInputObject;
import com.integ.scripting.objects.FourTwentyOutputObject;
import com.integ.scripting.objects.TempProbeObject;
import com.integ.scripting.objects.TenVoltInputObject;
import com.integ.scripting.objects.TenVoltOutputObject;
import com.integ.tasker.Unloadable;
import com.integ.tasker.WorkspaceConfigurationFile;
import com.integ.tasker.signals.SignalProfile;
import com.integ.tasker.signals.SignalProfilesCollection;
import com.integ.tasker.triggers.Trigger;
import com.integpg.janoslib.io.AppLog;
import java.util.Json;

public class ContinuousSignalTrigger
extends Trigger
implements Unloadable {
    private final Json _paramsJson;
    private final String _signalProfileName;
    private final String _triggerState;
    private SignalProfile _signalProfile;
    private final String _triggerComparator;
    private final double _triggerValue;
    private double _lastValue = -1.0;

    public ContinuousSignalTrigger(Json triggerJson) {
        this._paramsJson = (Json)triggerJson.get("Params");
        System.out.println("DiscreteSignalTrigger.paramsJson: " + this._paramsJson);
        this._triggerState = this._paramsJson.getString("State");
        System.out.println("_triggerState: " + this._triggerState);
        Json triggerSignalJson = (Json)this._paramsJson.get("Signal");
        System.out.println("_triggerSignalJson: " + triggerSignalJson);
        this._signalProfileName = triggerSignalJson.getString("Name");
        this._triggerComparator = this._paramsJson.getString("Comparator");
        System.out.println("_triggerComparator: " + this._triggerComparator);
        this._triggerValue = this._paramsJson.getDouble("Value");
        System.out.println("_triggerValue: " + this._triggerValue);
    }

    @Override
    public void setWorkspaceConfigurationFile(WorkspaceConfigurationFile workspaceConfigurationFile) {
        super.setWorkspaceConfigurationFile(workspaceConfigurationFile);
        this._workspaceConfigurationFile.addUnloadable(this);
        System.out.println("ContinuousSignalTrigger._signalProfileName: " + this._signalProfileName);
        SignalProfilesCollection signalProfilesCollection = workspaceConfigurationFile.getSignalProfilesCollection();
        if (signalProfilesCollection.containsSignalProfileName(this._signalProfileName)) {
            this._signalProfile = signalProfilesCollection.getByName(this._signalProfileName);
            System.out.println("ContinuousSignalTrigger._signalProfile" + this._signalProfile);
        }
    }

    @Override
    public void checkForTrigger() throws Throwable {
        if (Trigger.STATE.TRIGGERED == this._currentState) {
            return;
        }
        String deviceType = this._signalProfile.DeviceType;
        int channel = this._signalProfile.Channel;
        String fieldName = this._signalProfile.FieldName;
        String deviceString = String.format("%s[%d].%s", deviceType, channel, fieldName);
        double value = Double.NaN;
        try {
            Object result;
            if ("type28".equalsIgnoreCase(deviceType)) {
                result = TempProbeObject.read(channel, fieldName);
                value = (Double)result;
            } else if ("vin".equalsIgnoreCase(deviceType)) {
                result = TenVoltInputObject.read(channel, fieldName);
                value = (Double)result;
            } else if ("vout".equalsIgnoreCase(deviceType)) {
                result = TenVoltOutputObject.read(channel, fieldName);
                value = (Double)result;
            } else if ("iin".equalsIgnoreCase(deviceType)) {
                result = FourTwentyInputObject.read(channel, fieldName);
                value = (Double)result;
            } else if ("iout".equalsIgnoreCase(deviceType)) {
                result = FourTwentyOutputObject.read(channel, fieldName);
                value = (Double)result;
            } else if ("type7e".equalsIgnoreCase(deviceType)) {
                result = EnvironObject.read(channel, fieldName);
                value = (Double)result;
            }
        }
        catch (DeviceNotPresentException ex) {
            AppLog.warn(ex.getMessage());
            Thread.sleep(10000L);
        }
        catch (Exception ex) {
            AppLog.error(ex);
        }
        if (this._lastValue != value) {
            this._lastValue = value;
            System.out.println(String.format("ContinuousSignalTrigger for %s: %.3f %s %.3f", deviceString, value, this._triggerComparator, this._triggerValue));
        }
        boolean isTrigger = false;
        switch (this._triggerComparator) {
            case "<": {
                isTrigger = value < this._triggerValue;
                break;
            }
            case "<=": {
                isTrigger = value <= this._triggerValue;
                break;
            }
            case "=": {
                isTrigger = value == this._triggerValue;
                break;
            }
            case ">": {
                isTrigger = value > this._triggerValue;
                break;
            }
            case ">=": {
                boolean bl = isTrigger = value >= this._triggerValue;
            }
        }
        if (isTrigger) {
            this.trigger();
            System.out.println(this + " triggered!");
        }
    }

    @Override
    public void unload() {
    }
}

