/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.janoslib.externalio;

import com.integpg.janoslib.externalio.ExternalModule;
import com.integpg.janoslib.externalio.RegistryEnumerateModules;
import com.integpg.janoslib.system.RegistryHelper;
import com.integpg.janoslib.utils.HexUtils;
import com.integpg.system.ArrayUtils;
import com.integpg.system.JANOS;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.Date;

public class TypeFD
extends ExternalModule {
    private final byte[] _outBytes = new byte[8];
    public int[] RawOut = new int[2];
    public int[] RawIn = new int[4];
    private DecimalFormat df = new DecimalFormat("0.000");

    public static TypeFD getByIndex(int index) {
        String typeString = "TypeFD_" + (index + 1);
        String addressString = JANOS.getRegistryString((String)("externals/deviceorder/" + typeString), null);
        if (null != addressString) {
            if (!ModulesByAddress.containsKey(addressString)) {
                long address = HexUtils.parseHexAsLong(addressString);
                TypeFD typeFD = new TypeFD(address);
                typeFD.TypeIndex = index + 1;
                typeFD.TypeString = typeString;
                ModulesByAddress.put(addressString, typeFD);
            }
            return (TypeFD)ModulesByAddress.get(addressString);
        }
        return null;
    }

    public TypeFD(long address) {
        super(address);
    }

    public static TypeFD[] getDeviceArray() {
        RegistryEnumerateModules registryEnumerateModules = new RegistryEnumerateModules("FD");
        String[] externalDeviceAddressStrings = registryEnumerateModules.getExternalDeviceAddressStrings();
        TypeFD[] deviceArray = new TypeFD[externalDeviceAddressStrings.length];
        for (int i = 0; i < externalDeviceAddressStrings.length; ++i) {
            String deviceString = externalDeviceAddressStrings[i];
            System.out.println("found: " + deviceString);
            long deviceAddress = TypeFD.getDeviceAddressForDeviceString(deviceString);
            deviceArray[i] = new TypeFD(deviceAddress);
        }
        return deviceArray;
    }

    @Override
    public void read() throws IOException {
        int channel;
        this._dataBlock = JANOS.readDeviceBlock((long)this.Address);
        if (this._dataBlock.length != 12) {
            throw new IOException("Unable to read " + this.AddressString);
        }
        this.LastReadTime = System.currentTimeMillis();
        for (channel = 0; channel < 4; ++channel) {
            this.RawIn[channel] = ArrayUtils.getShort((byte[])this._dataBlock, (int)(channel * 2)) & 0xFFFF;
        }
        for (channel = 0; channel < 2; ++channel) {
            this.RawOut[channel] = ArrayUtils.getShort((byte[])this._dataBlock, (int)(channel * 2 + 8)) & 0xFFFF;
        }
        if (null != this.TypeString && RegistryHelper.getRegistryKey("Externals/" + this.TypeString + "/UpdateRegistryWithValues", false)) {
            JANOS.setRegistryString((String)("Externals/" + this.TypeString + "/$In1"), (String)String.valueOf(this.getScaledInput(1)));
            JANOS.setRegistryString((String)("Externals/" + this.TypeString + "/$In2"), (String)String.valueOf(this.getScaledInput(2)));
            JANOS.setRegistryString((String)("Externals/" + this.TypeString + "/$In3"), (String)String.valueOf(this.getScaledInput(3)));
            JANOS.setRegistryString((String)("Externals/" + this.TypeString + "/$In4"), (String)String.valueOf(this.getScaledInput(4)));
            JANOS.setRegistryString((String)("Externals/" + this.TypeString + "/$Out1"), (String)String.valueOf(this.getScaledOutput(1)));
            JANOS.setRegistryString((String)("Externals/" + this.TypeString + "/$Out2"), (String)String.valueOf(this.getScaledOutput(2)));
            JANOS.setRegistryString((String)("Externals/" + this.TypeString + "/$LastReadTime"), (String)QUICK_DATE_FORMAT.format(System.currentTimeMillis()));
        }
    }

    public void setChannelPercentage(int channel, double percent) {
        if (percent >= 0.0) {
            int raw = (int)(65535.0 * (percent / 100.0));
            ArrayUtils.setShort((byte[])this._outBytes, (int)(channel * 2), (short)((short)raw));
            ArrayUtils.setShort((byte[])this._outBytes, (int)(channel * 2 + 4), (short)0);
            System.out.println("set raw: " + raw);
        }
    }

    public void setChannelVoltage(int channel, double voltage) {
        double min = 0.0;
        double max = 10.0;
        double targetDelta = voltage - min;
        double totalDelta = max - min;
        double percentage = targetDelta / totalDelta;
        this.setChannelPercentage(channel, percentage * 100.0);
    }

    public void setChannel(int channel, int value) {
        if (value >= 0) {
            ArrayUtils.setShort((byte[])this._outBytes, (int)(channel * 2), (short)((short)value));
            ArrayUtils.setShort((byte[])this._outBytes, (int)(channel * 2 + 4), (short)0);
        }
    }

    public void fadeChannel(int channel, double percent, int duration) {
        int raw = (int)(65535.0 * (percent / 100.0));
        ArrayUtils.setShort((byte[])this._outBytes, (int)(channel * 2), (short)((short)raw));
        ArrayUtils.setShort((byte[])this._outBytes, (int)(channel * 2 + 4), (short)((short)duration));
    }

    public double getScaledInput(int channel) {
        String channelBaseString = "Externals/" + this.AddressString + "/Ain" + channel;
        double min = JANOS.getRegistryDouble((String)(channelBaseString + "/Min"), (double)-10.0);
        double max = JANOS.getRegistryDouble((String)(channelBaseString + "/Max"), (double)10.0);
        double value = this.scaleValue(this.RawIn[channel - 1], min, max);
        return value;
    }

    public double getScaledOutput(int channel) {
        String channelBaseString = "Externals/" + this.AddressString + "/Aout" + channel;
        double min = JANOS.getRegistryDouble((String)(channelBaseString + "/Min"), (double)0.0);
        double max = JANOS.getRegistryDouble((String)(channelBaseString + "/Max"), (double)100.0);
        double value = this.scaleValue(this.RawOut[channel - 1], min, max);
        return value;
    }

    @Override
    public void commit() {
        try {
            JANOS.writeDeviceBlock((long)this.Address, (byte[])this._outBytes);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void printValues() {
        int channel;
        System.out.println("Read " + this.AddressString + " @ " + new Date(this.LastReadTime));
        for (channel = 0; channel < 4; ++channel) {
            System.out.println("In " + (channel + 1) + ": " + this.RawIn[channel] + "   " + this.getScaledInput(channel + 1));
        }
        for (channel = 0; channel < 2; ++channel) {
            System.out.println("Out " + (channel + 1) + ": " + this.RawIn[channel] + "   " + this.getScaledOutput(channel + 1));
        }
    }

    @Override
    public double get(String fieldName) {
        System.out.println("typeFD.get(" + fieldName + ")");
        int channel = 1;
        int underscorePos = fieldName.indexOf("_");
        System.out.println("underscorePos: " + underscorePos);
        if (-1 != underscorePos) {
            channel = Integer.parseInt(fieldName.substring(underscorePos + 1));
            fieldName = fieldName.substring(0, underscorePos);
            System.out.println("typeFD.get(" + fieldName + ":" + channel + ")");
        }
        if ("rawin".equalsIgnoreCase(fieldName)) {
            return this.RawIn[channel - 1];
        }
        if ("scaledin".equalsIgnoreCase(fieldName)) {
            return this.getScaledInput(channel);
        }
        if ("rawout".equalsIgnoreCase(fieldName)) {
            return this.RawOut[channel - 1];
        }
        if ("scaledout".equalsIgnoreCase(fieldName)) {
            return this.getScaledOutput(channel);
        }
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

