/*
 * Decompiled with CFR 0.152.
 */
package com.integ.tasker.identifierobjects;

import com.integ.tasker.identifierobjects.ExternalIdentifierObject;
import com.integpg.janoslib.externalio.TypeFE;
import com.integpg.janoslib.io.AppLog;
import java.io.IOException;
import java.text.DecimalFormat;

class IinObject
extends ExternalIdentifierObject {
    private static final DecimalFormat DECIMAL_FORMAT = new DecimalFormat("0.00");
    private static final int CHANNELS_PER_MODULE = 4;

    public IinObject(String identifierName) {
        super(identifierName);
    }

    @Override
    public Object evaluate() {
        if (-1 == this._channel) {
            throw new RuntimeException("Four to Twenty input module channel expected");
        }
        if (null == this._fieldName) {
            throw new RuntimeException("Four to Twenty input module field name expected");
        }
        int moduleIndex = (this._channel - 1) / 4;
        TypeFE typeFe = TypeFE.getByIndex(moduleIndex);
        if (null != typeFe) {
            int readAttemptCount = 0;
            while (true) {
                if (0 > readAttemptCount) {
                    AppLog.error(String.format("retrying read for 4-20ma %s for input channel %d", this._fieldName, this._channel));
                }
                try {
                    typeFe.read();
                    super.resetReadFailCount();
                    int localChannel = (this._channel - 1) % 4 + 1;
                    System.out.println("localChannel: " + localChannel);
                    Object value = typeFe.get(String.format("%sin_%d", this._fieldName, localChannel));
                    if (value instanceof Double) {
                        return DECIMAL_FORMAT.format(value);
                    }
                    return value;
                }
                catch (IOException ex) {
                    AppLog.error(String.format("error getting 4-20ma %s for input channel %d", this._fieldName, this._channel), ex);
                    super.incrementReadFailCount();
                    if (super.shouldRetry(readAttemptCount)) continue;
                }
                break;
            }
        }
        return null;
    }
}

