/*
 * Decompiled with CFR 0.152.
 */
package com.integ.tasker;

import com.integpg.janoslib.io.AppLog;
import com.integpg.janoslib.system.Application;
import com.integpg.janoslib.system.RegistryHelper;
import java.io.File;

public class Config {
    private static final String APPDATA_ROOT = "AppData/" + Application.getAppName();
    public static final File TaskerDirectory = new File("/flash/tasker/");
    public static final File TaskerLoggingDirectory = new File("/flash/tasker/logging/");
    public static final File TaskerWorkspacesDirectory = new File("/flash/tasker/workspaces/");

    static void init() {
        Config.initializeDirectoryStructure();
        Config.getAsciiCommandServerPort();
        Config.getAsciiCommandSerialPort();
        Config.getAsciiCommandSerialPortSettings();
    }

    private static void initializeDirectoryStructure() {
        if (!TaskerDirectory.exists()) {
            AppLog.info("create " + TaskerDirectory.getPath());
            TaskerDirectory.mkdir();
        }
        if (!TaskerLoggingDirectory.exists()) {
            AppLog.info("create " + TaskerLoggingDirectory.getPath());
            TaskerLoggingDirectory.mkdir();
        }
        if (!TaskerWorkspacesDirectory.exists()) {
            AppLog.info("create " + TaskerWorkspacesDirectory.getPath());
            TaskerWorkspacesDirectory.mkdir();
        }
    }

    public static int getAsciiCommandServerPort() {
        return RegistryHelper.getRegistryKey(String.format("%s/AsciiCommandServerPort", APPDATA_ROOT), 9210);
    }

    static String getAsciiCommandSerialPort() {
        return RegistryHelper.getRegistryKey(String.format("%s/AsciiCommandSerialPort", APPDATA_ROOT), "none");
    }

    static String[] getAsciiCommandSerialPortSettings() {
        return RegistryHelper.getRegistryKeys(String.format("%s/AsciiCommandSerialPortSettings", APPDATA_ROOT), "9600,8,1,0");
    }
}

