/*
 * Decompiled with CFR 0.152.
 */
package com.integ.tasker.triggers;

import com.integ.scripting.exceptions.DeviceNotPresentException;
import com.integ.scripting.objects.EnvironObject;
import com.integ.scripting.objects.FourTwentyInputObject;
import com.integ.scripting.objects.FourTwentyOutputObject;
import com.integ.scripting.objects.TempProbeObject;
import com.integ.scripting.objects.TenVoltInputObject;
import com.integ.scripting.objects.TenVoltOutputObject;
import com.integ.tasker.signals.SignalProfile;
import com.integ.tasker.triggers.Trigger;
import com.integpg.janoslib.io.AppLog;
import java.util.Json;

class AnalogTrigger
extends Trigger {
    private final SignalProfile _triggerSignalProfile;
    private final String _triggerComparator;
    private final double _triggerValue;
    private double _lastValue = -1.0;

    public AnalogTrigger(SignalProfile triggerSignalProfile, Json triggerJson) {
        this._triggerSignalProfile = triggerSignalProfile;
        System.out.println("triggerJson: " + triggerJson);
        this._triggerComparator = triggerJson.getString("Comparator");
        System.out.println("_triggerComparator: " + this._triggerComparator);
        this._triggerValue = triggerJson.getDouble("Value");
        System.out.println("_triggerValue: " + this._triggerValue);
    }

    @Override
    public void detachListeners() {
    }

    @Override
    public boolean checkForTrigger() throws Throwable {
        String deviceType = this._triggerSignalProfile.DeviceType;
        int channel = this._triggerSignalProfile.Channel;
        String fieldName = this._triggerSignalProfile.FieldName;
        String deviceString = String.format("%s[%d].%s", deviceType, channel, fieldName);
        double value = Double.NaN;
        try {
            Object result;
            if ("type28".equalsIgnoreCase(deviceType)) {
                result = TempProbeObject.read(channel, fieldName);
                value = (Double)result;
            } else if ("vin".equalsIgnoreCase(deviceType)) {
                result = TenVoltInputObject.read(channel, fieldName);
                value = (Double)result;
            } else if ("vout".equalsIgnoreCase(deviceType)) {
                result = TenVoltOutputObject.read(channel, fieldName);
                value = (Double)result;
            } else if ("iin".equalsIgnoreCase(deviceType)) {
                result = FourTwentyInputObject.read(channel, fieldName);
                value = (Double)result;
            } else if ("iout".equalsIgnoreCase(deviceType)) {
                result = FourTwentyOutputObject.read(channel, fieldName);
                value = (Double)result;
            } else if ("type7e".equalsIgnoreCase(deviceType)) {
                result = EnvironObject.read(channel, fieldName);
                value = (Double)result;
            }
        }
        catch (DeviceNotPresentException ex) {
            AppLog.warn(ex.getMessage());
            Thread.sleep(10000L);
        }
        catch (Exception ex) {
            AppLog.error(ex);
        }
        if (this._lastValue != value) {
            this._lastValue = value;
            System.out.println(String.format("Analog Trigger for %s: %.3f %s %.3f", deviceString, value, this._triggerComparator, this._triggerValue));
        }
        boolean triggered = false;
        switch (this._triggerComparator) {
            case "<": {
                triggered = value < this._triggerValue;
                break;
            }
            case "<=": {
                triggered = value <= this._triggerValue;
                break;
            }
            case "=": {
                triggered = value == this._triggerValue;
                break;
            }
            case ">": {
                triggered = value > this._triggerValue;
                break;
            }
            case ">=": {
                triggered = value >= this._triggerValue;
            }
        }
        return triggered;
    }

    public String toString() {
        return " will trigger when " + this._triggerComparator + " " + this._triggerValue;
    }
}

