/*
 * Decompiled with CFR 0.152.
 */
package com.integ.tasker.triggers;

import com.integ.scripting.exceptions.DeviceNotPresentException;
import com.integ.scripting.objects.EnvironObject;
import com.integ.scripting.objects.FourTwentyInputObject;
import com.integ.scripting.objects.FourTwentyOutputObject;
import com.integ.scripting.objects.TempProbeObject;
import com.integ.scripting.objects.TenVoltInputObject;
import com.integ.scripting.objects.TenVoltOutputObject;
import com.integ.tasker.signals.SignalProfile;
import com.integ.tasker.triggers.Reset;
import com.integpg.janoslib.io.AppLog;
import java.util.Json;

class AnalogReset
extends Reset {
    private final SignalProfile _resetSignalProfile;
    private String _resetComparator;
    private final double _resetValue;
    private double _lastValue = -1.0;

    public AnalogReset(SignalProfile resetSignalProfile, Json triggerJson) {
        this._resetSignalProfile = resetSignalProfile;
        System.out.println("triggerJson: " + triggerJson);
        this._resetComparator = triggerJson.getString("Comparator");
        System.out.println("_resetComparator: " + this._resetComparator);
        this._resetValue = triggerJson.getDouble("Value");
        System.out.println("_resetValue: " + this._resetValue);
    }

    @Override
    public void detachListeners() {
    }

    @Override
    public void makeReset() {
        switch (this._resetComparator) {
            case "<": {
                this._resetComparator = ">=";
                break;
            }
            case "<=": {
                this._resetComparator = ">";
                break;
            }
            case "=": {
                this._resetComparator = "!=";
                break;
            }
            case ">": {
                this._resetComparator = "<=";
                break;
            }
            case ">=": {
                this._resetComparator = "<";
            }
        }
    }

    @Override
    public void clearReset() {
    }

    @Override
    public boolean checkForReset() throws Throwable {
        String deviceType = this._resetSignalProfile.DeviceType;
        int channel = this._resetSignalProfile.Channel;
        String fieldName = this._resetSignalProfile.FieldName;
        String deviceString = String.format("%s[%d].%s", deviceType, channel, fieldName);
        double value = Double.NaN;
        try {
            Object result;
            if ("type28".equalsIgnoreCase(deviceType)) {
                result = TempProbeObject.read(channel, fieldName);
                value = (Double)result;
            } else if ("vin".equalsIgnoreCase(deviceType)) {
                result = TenVoltInputObject.read(channel, fieldName);
                value = (Double)result;
            } else if ("vout".equalsIgnoreCase(deviceType)) {
                result = TenVoltOutputObject.read(channel, fieldName);
                value = (Double)result;
            } else if ("iin".equalsIgnoreCase(deviceType)) {
                result = FourTwentyInputObject.read(channel, fieldName);
                value = (Double)result;
            } else if ("iout".equalsIgnoreCase(deviceType)) {
                result = FourTwentyOutputObject.read(channel, fieldName);
                value = (Double)result;
            } else if ("type7e".equalsIgnoreCase(deviceType)) {
                result = EnvironObject.read(channel, fieldName);
                value = (Double)result;
            }
        }
        catch (DeviceNotPresentException ex) {
            Thread.sleep(10000L);
            AppLog.warn(ex.getMessage());
        }
        catch (Exception ex) {
            AppLog.error(ex);
        }
        if (this._lastValue != value) {
            this._lastValue = value;
            System.out.println(String.format("Analog Reset for %s: %.3f %s %.3f", deviceString, value, this._resetComparator, this._resetValue));
        }
        boolean triggered = false;
        switch (this._resetComparator) {
            case "<": {
                triggered = value < this._resetValue;
                break;
            }
            case "<=": {
                triggered = value <= this._resetValue;
                break;
            }
            case "=": {
                triggered = value == this._resetValue;
                break;
            }
            case "!=": {
                triggered = value != this._resetValue;
                break;
            }
            case ">": {
                triggered = value > this._resetValue;
                break;
            }
            case ">=": {
                triggered = value >= this._resetValue;
            }
        }
        return triggered;
    }

    public String toString() {
        return " will reset when " + this._resetComparator + " " + this._resetValue;
    }
}

