/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.janoslib.externalio;

import com.integpg.janoslib.text.QuickDateFormat;
import com.integpg.sensor.SensorPort;
import com.integpg.system.JANOS;
import java.util.Hashtable;

public abstract class ExternalModule {
    protected static final SensorPort SENSOR_PORT = new SensorPort();
    protected static final QuickDateFormat QUICK_DATE_FORMAT = new QuickDateFormat("yyyy-MM-dd HH:mm:ss zzz");
    public static final String INTEG_PEN = "1.3.6.1.4.1.31976";
    public long Address;
    public String AddressString;
    public int TypeIndex;
    public String TypeString;
    public long LastReadTime;
    public long LastWriteTime;
    protected byte[] _dataBlock;
    protected static String[] _externalDevices;
    protected static final Hashtable<String, ExternalModule> ModulesByAddress;

    protected static long getDeviceAddressForDeviceString(String deviceTypeIndex) {
        String addressString = JANOS.getRegistryString((String)("Externals/DeviceOrder/" + deviceTypeIndex), (String)"");
        int len = addressString.length();
        long address = Long.parseLong(addressString.substring(0, len - 8), 16);
        address <<= 32;
        return address += Long.parseLong(addressString.substring(len - 8), 16);
    }

    public ExternalModule(long address) {
        this.setAddress(address);
    }

    public ExternalModule(long address, int index) {
        this.setAddress(address);
        this.TypeIndex = index;
    }

    private void setAddress(long address) {
        this.Address = address;
        this.AddressString = "0000000000000000" + Long.toHexString(address);
        this.AddressString = this.AddressString.substring(this.AddressString.length() - 16);
    }

    public long getMinReadInterval() {
        return 0L;
    }

    public abstract void read() throws Throwable;

    public abstract void commit();

    public byte[] getDataBlock() {
        return this._dataBlock;
    }

    public abstract void printValues();

    public float scaleValue(int raw, double min, double max) {
        double percent = (double)raw / 65535.0;
        return (float)(percent * (max - min) + min);
    }

    public abstract Object get(String var1);

    static {
        ModulesByAddress = new Hashtable();
    }
}

