/*
 * Decompiled with CFR 0.152.
 */
package com.integ.tasker.devices;

import com.integ.janoslib.messagepump.MessagePumpEngine;
import com.integ.tasker.devices.Device;
import com.integ.tasker.webhandlers.ErrorMessage;
import java.util.Json;

public class EthernetDevice
extends Device {
    private String _ipAddress;
    private int _port;

    public EthernetDevice(Json json) {
        super(json);
        try {
            Json paramsJson = (Json)json.get("Params");
            this._ipAddress = paramsJson.getString("IpAddress");
            this._port = paramsJson.getInt("Port");
            LOG.info(String.format("ipAddress: %s, port: %d", this._ipAddress, this._port));
        }
        catch (Throwable ex) {
            Throwable throwable = new Exception("unable to load " + this.Name).initCause(ex);
            LOG.error(throwable);
            ErrorMessage message = new ErrorMessage(throwable);
            MessagePumpEngine.postMessage(message.build());
        }
    }

    public String getIpAddress() {
        return this._ipAddress;
    }

    public int getPort() {
        return this._port;
    }
}

