/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.janoslib.externalio;

import com.integpg.janoslib.externalio.ExternalModule;
import com.integpg.janoslib.externalio.Type28;
import com.integpg.janoslib.externalio.Type7E;
import com.integpg.janoslib.externalio.TypeF9;
import com.integpg.janoslib.externalio.TypeFA;
import com.integpg.janoslib.externalio.TypeFB;
import com.integpg.janoslib.externalio.TypeFD;
import com.integpg.janoslib.externalio.TypeFE;
import com.integpg.janoslib.utils.HexUtils;
import java.util.Hashtable;

public class ExternalDeviceFactory {
    private static final Hashtable<Long, ExternalModule> Modules_By_Address = new Hashtable();

    public static ExternalModule createFromAddressString(String addressString) {
        long address = HexUtils.parseHexAsLong(addressString);
        return ExternalDeviceFactory.createFromAddress(address);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ExternalModule createFromAddress(long address) {
        Hashtable<Long, ExternalModule> hashtable = Modules_By_Address;
        synchronized (hashtable) {
            if (Modules_By_Address.contains(address)) {
                return Modules_By_Address.get(address);
            }
            ExternalModule externalModule = null;
            int type = (int)(address & 0xFFL);
            switch (type) {
                case 16: 
                case 40: {
                    externalModule = new Type28(address);
                    break;
                }
                case 126: {
                    externalModule = new Type7E(address);
                    break;
                }
                case 249: {
                    externalModule = new TypeF9(address);
                    break;
                }
                case 250: {
                    externalModule = new TypeFA(address);
                    break;
                }
                case 251: {
                    externalModule = new TypeFB(address);
                    break;
                }
                case 253: {
                    externalModule = new TypeFD(address);
                    break;
                }
                case 254: {
                    externalModule = new TypeFE(address);
                }
            }
            if (null != externalModule) {
                Modules_By_Address.put(address, externalModule);
            }
            return externalModule;
        }
    }
}

