function parseTimingAction(json) {
    var method = json.Method;

    switch (method) {
        case 'At':
            return new AtAction();

        case 'Sleep':
            return new SleepAction(undefined, 'seconds');

        default:
            throw new Error('Unknown Timing Action Method: ' + JSON.stringify(json, null, 2));
    }
}



///////////////////////////////////////////////////////////////////////////////////////////////////
//
//                                         Timing Control Actions
//
///////////////////////////////////////////////////////////////////////////////////////////////////

class AtAction extends Action {
    constructor(seconds) {
        super();
        this.Type = 'Timing';
        this.Method = 'At';
        this.Params.Seconds = seconds || 1;
        this.Params.Actions = [];
    }

    editTemplate() {
        return 'At <input name="' + guid() + '" required class="form-control" type="text" ng-model="action.Params.Seconds" /> <br>' +
            '<action-block actions="action.Params.Actions" parent="action" tasker-ctrl="tasker" task-ctrl="taskCtrl">' +
            '</action-block>';
    }
}



class SleepAction extends Action {
    constructor(duration, timingUnits) {
        super();
        this.Type = 'Timing';
        this.Method = 'Sleep';
        this.Params.Duration = duration || 1;
        // this.Params.TimingUnits = timingUnits || 'milliseconds';
    }

    editTemplate() {
        return 'Sleep for ' +
            '<input name="' + guid() + '" required' +
            ' class="form-control" type="text" ng-model="action.Params.Duration"' +
            ' data-toggle="tooltip" title="Length of sleep in seconds.  Seconds can be represented with a decimal point and do not need to be whole seconds."' +
            ' style="width: 125px" /> seconds';
    }
}