/*
 * Decompiled with CFR 0.152.
 */
package com.integ.tasker.devices;

import com.integ.tasker.devices.ServerDevice;
import com.integ.tasker.web.messages.ErrorMessage;
import com.integpg.janoslib.messagepump.MessagePumpEngine;
import com.integpg.janoslib.net.udp.UdpConnectionListener;
import com.integpg.janoslib.net.udp.UdpServer;
import com.integpg.janoslib.net.udp.UdpServerEvent;
import com.integpg.janoslib.utils.HexUtils;
import java.util.Json;

public class UDPServerDevice
extends ServerDevice
implements UdpConnectionListener {
    private int _port;
    private UdpServer _udpServer = null;

    public UDPServerDevice(Json json) {
        super(json);
        try {
            Json paramsJson = (Json)json.get("Params");
            this._port = paramsJson.getInt("Port");
            LOG.info(String.format("UDP Server Device: port: %d", this._port));
            this._udpServer = new UdpServer("OSC UDP Server", this._port);
        }
        catch (Throwable ex) {
            Throwable throwable = new Exception("unable to load " + this.Name).initCause(ex);
            LOG.error(throwable);
            ErrorMessage message = new ErrorMessage(throwable);
            MessagePumpEngine.postMessage(message.build());
        }
    }

    public int getPort() {
        return this._port;
    }

    public void setListener(UdpConnectionListener listener) {
        this._udpServer.setListener(listener);
    }

    @Override
    public void start() {
        this._udpServer.start();
    }

    @Override
    public void stop() {
        this._udpServer.stop();
    }

    @Override
    public void processMessage(UdpServerEvent udpServerEvent) {
        byte[] messageBytes = udpServerEvent.getPacket().getData();
        System.out.println("received OSC" + HexUtils.hexDump(messageBytes));
    }
}

