/*
 * Decompiled with CFR 0.152.
 */
package com.integ.tasker.lexer;

import com.integ.tasker.lexer.Token;
import com.integpg.janoslib.collections.Queue;

public class TokenStream {
    private final Queue _tokens;
    private Token _current;
    private boolean _printDebug = false;

    public TokenStream(Queue tokens) {
        this._tokens = tokens;
    }

    public void clear() {
        this._tokens.clear();
        this._current = null;
    }

    public void printDebug(boolean enabled) {
        this._printDebug = enabled;
    }

    public Token getCurrent() {
        if (null == this._current) {
            this.nextToken();
        }
        return this._current;
    }

    public Token currentToken() {
        if (null == this._current) {
            this.nextToken();
        }
        return this._current;
    }

    public boolean isEmpty() {
        return this._tokens.isEmpty();
    }

    public Token peekToken() {
        if (0 == this._tokens.size()) {
            return null;
        }
        Token peek = (Token)this._tokens.elementAt(0);
        if (this._printDebug) {
            System.out.println("   peek next token: " + peek.toString());
        }
        return peek;
    }

    public Token nextToken() {
        if (this.isEmpty()) {
            throw new RuntimeException("End of Tokens");
        }
        this._current = (Token)this._tokens.dequeue();
        if (this._printDebug) {
            System.out.println("   next token: " + this._current.toString());
        }
        return this._current;
    }

    public int size() {
        return this._tokens.size();
    }
}

