/*
 * Decompiled with CFR 0.152.
 */
package com.integ.tasker.tasks.actions.network;

import com.integ.janoslib.messagepump.MessagePumpEngine;
import com.integ.tasker.devices.DeviceCollection;
import com.integ.tasker.devices.DeviceProfile;
import com.integ.tasker.devices.projectors.ProjectorDevice;
import com.integ.tasker.tasks.Task;
import com.integ.tasker.tasks.TaskRuntime;
import com.integ.tasker.tasks.actions.Action;
import com.integ.tasker.web.messages.ErrorMessage;
import com.integpg.janoslib.logger.AppLog;
import java.util.Json;

public class ProjectorSend
extends Action {
    private final String _deviceAction;

    public ProjectorSend(Task parentTask, Json json) {
        super(parentTask, json);
        String deviceGuid = this._paramsJson.getString("DeviceGUID");
        DeviceProfile device = DeviceCollection.GLOBAL.getByDeviceGUID(deviceGuid);
        if (null == device) {
            throw new RuntimeException("No device found for " + deviceGuid);
        }
        System.out.println("projector device = " + device);
        if (!(device instanceof ProjectorDevice)) {
            throw new RuntimeException("Device found for " + deviceGuid + " is not an Projector Device");
        }
        this._deviceAction = this._paramsJson.getString("DeviceAction");
        Json deviceActionJson = new Json();
        deviceActionJson.put("type", (Object)"ProjectorSend");
        deviceActionJson.put("name", (Object)device.Name);
        deviceActionJson.put("deviceAction", (Object)this._deviceAction);
        this._parentTask.addDeviceActionJson(deviceActionJson);
    }

    @Override
    public void execute(TaskRuntime taskRuntime) throws Throwable {
        try {
            String deviceGuid = this._paramsJson.getString("DeviceGUID");
            try {
                if (null == deviceGuid || "".equals(deviceGuid)) {
                    throw new RuntimeException("No device was selected for this TCP Send");
                }
                DeviceProfile device = DeviceCollection.GLOBAL.getByDeviceGUID(deviceGuid);
                if (null == device) {
                    throw new RuntimeException("No device found for " + deviceGuid);
                }
                if (!(device instanceof ProjectorDevice)) {
                    throw new RuntimeException("Device found for " + deviceGuid + " is not an Projector Device");
                }
                ProjectorDevice projectorDevice = (ProjectorDevice)device;
                byte[] commandBytes = projectorDevice.getCommandBytes(this._paramsJson);
                try {
                    projectorDevice.send(commandBytes);
                }
                catch (Exception ex) {
                    throw new RuntimeException(String.format("Error sending %s to %s - %s", this._deviceAction, projectorDevice.toString(), ex.getMessage()));
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                AppLog.warn(ex.getMessage());
                ErrorMessage errorMessage = new ErrorMessage(ex.getMessage());
                MessagePumpEngine.postMessage(errorMessage.build());
            }
        }
        catch (Exception ex) {
            throw new Exception("Error executing Projector Send").initCause(ex);
        }
    }

    public String toString() {
        return String.format("%s", this._deviceAction);
    }
}

