/*
 * Decompiled with CFR 0.152.
 */
package com.integ.tasker.signals;

import com.integpg.janoslib.logger.AppLog;
import java.util.Json;

public class SignalProfile {
    public static final SignalProfile ANY_INPUT = new SignalProfile(new Json("{ \"Name\": \"Any Input\", \"SelectedDevice\": \"DIN\", \"SelectedDeviceChannel\": -1, \"SelectedDeviceVariable\":\"State\" }"));
    public static final SignalProfile ANY_OUTPUT = new SignalProfile(new Json("{ \"Name\": \"Any Output\", \"SelectedDevice\": \"ROUT\", \"SelectedDeviceChannel\": -1, \"SelectedDeviceVariable\":\"State\" }"));
    public String Name;
    public String DeviceType;
    public IO_TYPE IoType = IO_TYPE.Input;
    public int Channel;
    public String FieldName;

    public SignalProfile(Json signalProfileJson) {
        try {
            this.Name = signalProfileJson.getString("Name");
            this.DeviceType = signalProfileJson.getString("SelectedDevice");
            if (!signalProfileJson.containsKey("SelectedDeviceChannel")) {
                throw new Exception("Missing SelectedDeviceChannel");
            }
            this.Channel = signalProfileJson.getInt("SelectedDeviceChannel");
            this.FieldName = signalProfileJson.getString("SelectedDeviceVariable");
        }
        catch (Exception ex) {
            AppLog.error("error processing signal profile for " + this.Name + ": " + signalProfileJson, ex);
        }
    }

    public String getDeviceString() {
        return String.format("%s[%d].%s", this.DeviceType, this.Channel, this.FieldName);
    }

    public String toString() {
        return String.format("Signal Profile @%s, Name=%s, %s[%d].%s", Integer.toHexString(this.hashCode()), this.Name, this.DeviceType, this.Channel, this.FieldName);
    }

    public static enum IO_TYPE {
        Input,
        Output;

    }
}

