var WORKSPACE_STORAGE_DIRECTORY = "/flash/tasker/workspaces/";


function WorkspaceFile(jnrWebsocket, workspaceFileEntry) {
    var _this = this;
    _this.JnrWebsocket = jnrWebsocket;
    _this.Config = {
        Version: APP.getVersion(),
        TaskList: [],
        DeviceList: [],
        LoggerList: [],
        SignalList: [],
        TriggerList: [],
        ScheduleList: []
    };
    _this.SavedConfig = angular.copy(_this.Config);


    // listeners
    _this.workspaceOpened = null;


    _this.isEnabled = function () {
        _this.Enabled = !_this.Name.startsWith('#');
        return _this.Enabled;
    };



    _this.setName = function (name) {
        _this.Name = name;
        _this.FilePath = WORKSPACE_STORAGE_DIRECTORY + name;
        _this.isEnabled();
    };
    _this.setName(workspaceFileEntry ? workspaceFileEntry.Name : '');




    /**
     * opens the workspace with the given jnrwebsocket connection
     */
    this.open = function () {
        var workspaceFileName = WORKSPACE_STORAGE_DIRECTORY + _this.Name;
        _this.JnrWebsocket.readFile(workspaceFileName, function (result) {
            // the callback indicates that the workspace file has been read
            if ('Fail' !== result.Status) {
                var fileContents = Base64.decode(result.Data);
                _this.Config = JSON.parse(fileContents);
                _this.SavedConfig = angular.copy(_this.Config);

                // alert the workspace opened listener
                if (_this.workspaceOpened) _this.workspaceOpened(_this);
            }
        });
    };



    /**
     * This function returns a json string representation of the onject but
     * removes any Circular references and $$haskKey properties.  Err objects
     * are also removed
     */
    _this.getJson = function (json) {
        if (undefined == json || null == json) json = _this.Config;

        return JSON.stringify(json, function replacer(key, value) {
            if ('$$hashKey' === key || 'Parent' === key) return;
            if ('Err' === key) return;
            return value;
        }, 2);
    };



    /**
     * saves the current configuration.  
     */
    _this.save = function (callback) {
        _this.Config.Version = APP.getVersion();
        var fileContent = _this.getJson(_this.Config);
        JnrWebsocket.writeFile(_this.FilePath, fileContent, function () {
            _this.SavedConfig = angular.copy(_this.Config);
            callback();
        });
    };



    /**
     * saves the current configuration as a new name.
     */
    _this.saveas = function (newName, callback) {
        _this.setName(newName);
        _this.save(callback);
    };



    /**
     * renames the workspace with the given new name
     * 
     * @param {*} newName 
     */
    _this.rename = function (newName, callback) {
        var newWorkspaceFilePath = WORKSPACE_STORAGE_DIRECTORY + newName;
        JnrWebsocket.renameFile(_this.FilePath, newWorkspaceFilePath).then(function () {
            _this.Name = newName;
            _this.FilePath = WORKSPACE_STORAGE_DIRECTORY + _this.Name;
            _this.isEnabled();

            callback();
        });
    };



    /**
     * deletes this workspace file from the jnior
     * 
     * @param {*} callback 
     */
    _this.delete = function (callback) {
        // try to remove a current .bak version and move the current json file 
        // to the bak file
        JnrWebsocket.removeFile(_this.FilePath).then(function () {
            JnrWebsocket.renameFile(_this.FilePath, _this.FilePath + '.bak');
        });

        // now delete the json file for this workspace
        JnrWebsocket.removeFile(_this.FilePath).then(callback);
    }



    _this.getSummary = function () {
        var summary = '';
        if (0 < _this.Config.TaskList.length) {
            summary += _this.Config.TaskList.length + ' Task';
            if (1 < _this.Config.TaskList.length) summary += 's';
        }
        if (0 < _this.Config.TriggerList.length) {
            if (0 < summary.length) summary += ', ';
            summary += _this.Config.TriggerList.length + ' Trigger';
            if (1 < _this.Config.TriggerList.length) summary += 's';
        }
        if (0 < _this.Config.ScheduleList.length) {
            if (0 < summary.length) summary += ', ';
            summary += _this.Config.ScheduleList.length + ' Schedule';
            if (1 < _this.Config.ScheduleList.length) summary += 's';
        }
        return summary;
    };
}