/* global bootbox, Tasker */

TaskerApp.controller('ScheduleController', function ($scope, $compile, ScheduleService, TaskService) {
    var _this = this;



    _this.getTasks = function () {
        return TaskService.TaskList;
    };



    _this.getDescription = function (scheduleJson) {
        try {
            switch (scheduleJson.ScheduleType) {
                case 'Schedule':
                    var result = '';

                    var timeOptions = scheduleJson.TimeOptions;
                    if (timeOptions) {

                        var dateOptions = scheduleJson.DateOptions;
                        var dateString = '';
                        if (dateOptions) {
                            switch (dateOptions.DateRecurranceType) {
                                case 'Daily':
                                    var dateRecurranceInterval = dateOptions.DateRecurranceInterval;
                                    if (1 == dateRecurranceInterval) dateString = 'Daily';
                                    else if (2 == dateRecurranceInterval) dateString = 'Every Other Day';
                                    else if (0 == dateRecurranceInterval % 7) {
                                        var weeks = dateRecurranceInterval / 7;
                                        if (1 == weeks) dateString = 'Every week';
                                        else dateString = 'Every ' + weeks + ' weeks';
                                    }
                                    else dateString = 'Every ' + dateRecurranceInterval + ' days';
                                    break;

                                case 'Weekly':
                                    var daysOfWeek = ['Sunday', 'Monday', 'Tuesday', 'Wednesday', 'Thursday', 'Friday', 'Saturday'];
                                    for (var i = 0; i < daysOfWeek.length; i++) {
                                        var day = daysOfWeek[i];
                                        var dayEnabled = dateOptions.Days[day];
                                        if (dayEnabled) {
                                            if (0 < dateString.length) dateString += ', ';
                                            dateString += day;
                                        }
                                    }
                                    dateString = 'on ' + dateString;
                                    break;

                                case 'None':
                                    dateString = 'on ' + dateOptions.StartDate;
                                    break;

                            }
                        }

                        var start = timeOptions.Start;
                        startTime = start.Hour.leftPad(2) + ':' + start.Minute.leftPad(2);
                        if (0 == start.Hour && 0 == start.Minute) startTime = 'Midnight';
                        if (12 == start.Hour && 0 == start.Minute) startTime = 'Noon';

                        if (0 < timeOptions.RepeatInterval) {
                            var end = timeOptions.End;
                            var endTime = '';
                            if (end) {
                                endTime = end.Hour.leftPad(2) + ':' + end.Minute.leftPad(2);
                                if (0 == end.Hour && 0 == end.Minute) endTime = 'Midnight';
                                if (12 == end.Hour && 0 == end.Minute) endTime = 'Noon';
                            }

                            var repeatString = timeOptions.RepeatInterval + ' ' + timeOptions.RepeatIntervalUnits;
                            if (1 == timeOptions.RepeatInterval) repeatString =
                                timeOptions.RepeatIntervalUnits.substring(0, timeOptions.RepeatIntervalUnits.length - 1);
                            result += 'Repeat every ' + repeatString +
                                ' starting at ' + startTime + ' until ' + endTime + ' ' + dateString;
                        } else {
                            result += 'Execute  at ' + startTime + ' ' + dateString;
                        }
                    }

                    return result;

                case 'Sunrise':
                case 'Sunset':
                    return 'Task will execute at ' + scheduleJson.ScheduleType;

                case 'On Boot':
                    return 'Task will execute on boot';

            }
        } catch (err) {
            return 'Invalid Format: Most likely because of development';
        }
    }



    _this.areSchedulesLoaded = function () {
        return ScheduleService.SchedulesLoaded;
    };



    _this.getSchedules = function () {
        return ScheduleService.ScheduleList;
    };



    _this.selectSchedule = function (schedule) {
        ScheduleService.SelectedSchedule = schedule;
    };


    _this.getSelectedSchedule = function () {
        return ScheduleService.SelectedSchedule;
    };



    _this.SelectedSchedule = null;
    _this.addSchedule = function () {
        if (undefined != _this.addScheduleDialog) return;

        _this.addScheduleDialog = bootbox.prompt({
            className: 'bb-success',
            title: "What is the name of the new Schedule?",
            buttons: {
                cancel: {
                    label: 'Cancel',
                    className: 'btn-default'
                },
                confirm: {
                    label: 'Add',
                    className: 'btn-success'
                }
            },
            callback: function (result) {
                if (result) {

                    if (undefined == ScheduleService.ScheduleList) ScheduleService.ScheduleList = [];
                    var schedule = new ScheduleObject(result);
                    // make sure it is enabled by default
                    schedule.Params.Enabled = true;
                    ScheduleService.ScheduleList.push(schedule);

                    $scope.$apply();
                } else return (null == result);
            }
        }).init(function () {
            validate_alphanumeric($(".bootbox-input"));
            confirm_or_submit_on_enter($(".bootbox-input"));
        }).on('shown.bs.modal', function () {
            $('.bootbox-input').focus();
        }).on('hidden.bs.modal', function () {
            _this.addScheduleDialog = undefined;
        });
    };



    _this.editScheduleName = function (schedule) {
        if (undefined != _this.editScheduleNameDialog) return;

        _this.editScheduleNameDialog = bootbox.prompt({
            className: 'bb-primary',
            title: "Edit the name of the Schedule?",
            // message: '<p class="alert alert-warning"><b>Careful!</b>  Changing the name of the' +
            //     ' Schedule can have negative consequences if it it referenced elsewhere in Tasker. ' +
            //     ' Please make sure to change the name used in the references.</p>',
            buttons: {
                cancel: {
                    label: 'Cancel',
                    className: 'btn-default'
                },
                confirm: {
                    label: 'Update',
                    className: 'btn-success'
                }
            },
            value: schedule.Name,
            callback: function (result) {
                if (result) {
                    schedule.Name = result;
                    $scope.$apply();
                }
            }
        }).init(function () {
            validate_alphanumeric($(".bootbox-input"));
            confirm_or_submit_on_enter($(".bootbox-input"));
        }).on('shown.bs.modal', function () {
            $('.bootbox-input').focus();
        }).on('hidden.bs.modal', function () {
            _this.editScheduleNameDialog = undefined;
        });
    };



    _this.removeSchedule = function (schedule) {
        if (undefined != _this.removeScheduleDialog) return;

        _this.removeScheduleDialog = bootbox.confirm({
            className: 'bb-warning',
            title: "Are you sure?",
            message: "Are you sure you wish to remove the '" + schedule.Name + "' schedule?",
            buttons: {
                cancel: {
                    label: 'Cancel',
                    className: 'btn-default'
                },
                confirm: {
                    label: 'Remove',
                    className: 'btn-warning'
                }
            },
            callback: function (result) {
                if (result) {

                    var index = ScheduleService.ScheduleList.indexOf(schedule);
                    if (-1 != index) {
                        ScheduleService.ScheduleList.splice(index, 1);
                    }

                    $scope.$apply();
                }
            }
        }).init(function () {
            confirm_or_submit_on_enter($(".bootbox"));
        }).on('hidden.bs.modal', function () {
            _this.removeScheduleDialog = undefined;
        });
    };



    _this.addRuleToSchedule = function (schedule) {
        _this.SelectedRule = { ScheduleType: "Schedule" };

        var template = '<div ng-include="\'schedules/schedule.html\'"></div>';
        var linkFn = $compile(template);
        var html = linkFn($scope);

        if (undefined != _this.addRuleDialog) return;

        _this.addRuleDialog = bootbox.dialog({
            className: 'bb-primary',
            title: "Schedule Rule",
            message: html,
            buttons: {
                cancel: {
                    label: 'Cancel',
                    className: 'btn-default'
                },
                confirm: {
                    label: 'Add',
                    className: 'btn-success',
                    callback: function (result) {
                        if (result) {
                            var form = $("#rule-form");
                            form.validate({ errorPlacement: function (error, element) { } });

                            if (form.valid()) {
                                if (undefined == schedule.Params) schedule.Params = {};
                                if (undefined == schedule.Params.Rules) schedule.Params.Rules = [];
                                schedule.Params.Rules.push(_this.SelectedRule);

                                $scope.$apply();
                            } else return false;
                        }
                    }
                }
            }
        }).on('hidden.bs.modal', function () {
            _this.addRuleDialog = undefined;
        });

    };



    _this.editRule = function (rule) {
        if (rule) _this.SelectedRule = angular.copy(rule);
        else _this.SelectedRule = {};

        var template = '<div ng-include="\'schedules/schedule.html\'"></div>';
        var linkFn = $compile(template);
        var html = linkFn($scope);

        if (undefined != _this.editRuleDialog) return;

        _this.editRuleDialog = bootbox.dialog({
            className: 'bb-primary',
            title: "Schedule Rule",
            message: html,
            buttons: {
                cancel: {
                    label: 'Cancel',
                    className: 'btn-default'
                },
                confirm: {
                    label: 'OK',
                    className: 'btn-success',
                    callback: function (result) {
                        if (result) {
                            var form = $("#rule-form");
                            form.validate({ errorPlacement: function (error, element) { } });

                            if (form.valid()) {
                                rule.ScheduleType = _this.SelectedRule.ScheduleType;
                                rule.TimeOptions = angular.copy(_this.SelectedRule.TimeOptions);
                                rule.DateOptions = _this.SelectedRule.DateOptions;

                                $scope.$apply();
                            } else return false;
                        }
                    }
                }
            }
        }).init(function () {
            validate_alphanumeric($(".bootbox-input"));
            confirm_or_submit_on_enter($(".bootbox-input"));
        }).on('hidden.bs.modal', function () {
            _this.editRuleDialog = undefined;
        });
    };



    _this.removeRuleFromSchedule = function (rule, schedule) {
        if (undefined != _this.removeScheduleDialog) return;

        _this.removeScheduleDialog = bootbox.confirm({
            className: 'bb-warning',
            title: "Are you sure?",
            message: "Are you sure you wish to remove the rule from the '" + schedule.Name + "' schedule?",
            buttons: {
                cancel: {
                    label: 'Cancel',
                    className: 'btn-default'
                },
                confirm: {
                    label: 'Remove',
                    className: 'btn-warning'
                }
            },
            callback: function (result) {
                if (result) {
                    var index = schedule.Params.Rules.indexOf(rule);
                    if (0 <= index) {
                        schedule.Params.Rules.splice(index, 1);
                        $scope.$apply();
                    }
                }
            }
        }).init(function () {
            confirm_or_submit_on_enter($(".bootbox-input"));
        }).on('hidden.bs.modal', function () {
            _this.removeScheduleDialog = undefined;
        });
    };



    _this.moveUp = function (schedule, currentIndex) {
        // remove from current position
        ScheduleService.ScheduleList.splice(currentIndex, 1);

        // assign the schedule to the previous position 
        ScheduleService.ScheduleList.splice(currentIndex - 1, 0, schedule);
    };



    _this.moveDown = function (schedule, currentIndex) {
        // remove from current position
        ScheduleService.ScheduleList.splice(currentIndex, 1);

        // assign the schedule to the previous position 
        ScheduleService.ScheduleList.splice(currentIndex + 1, 0, schedule);
    };
});



/*
   SERVICE
*/
TaskerApp.service('ScheduleService', function ($rootScope, TaskService) {
    var _this = this;
    _this.ScheduleList = [];
    _this.SelectedSchedule = null;
    _this.SchedulesLoaded = false;



    _this.load = function (scheduleListJson) {
        if (undefined == scheduleListJson) scheduleListJson = [];

        try {
            parseScheduleList(scheduleListJson);
        } catch (err) {
            console.error(err);
        }

        _this.SelectedSchedule = null;
        _this.SchedulesLoaded = true;

        return _this.ScheduleList;
    };



    function parseScheduleList(scheduleArray) {
        // empty our array of schedules
        _this.ScheduleList = [];

        scheduleArray.forEach(function (scheduleJson) {
            var schedule = new ScheduleObject(scheduleJson.Name, scheduleJson.Params);
            schedule.GUID = scheduleJson.GUID;
            _this.ScheduleList.push(schedule);
        });
    };



    _this.isValid = true;
    _this.validate = function () {
        var form = $("#schedule-form");
        if (0 < form.length) {
            form.validate({ ignore: ".ignore", errorPlacement: function (error, element) { } });
            _this.isValid = form.valid();
        } else _this.isValid = true;
        return _this.isValid;
    };
});