/*
 * Decompiled with CFR 0.152.
 */
package com.integ.tasker.tasks.actions.controlstructures;

import com.integ.tasker.tasks.Task;
import com.integ.tasker.tasks.TaskRuntime;
import com.integ.tasker.tasks.actions.Action;
import com.integpg.tasker.TextReplacer;
import com.integpg.tasker.ast.ASTNode;
import com.integpg.tasker.ast.ASTParser;
import java.util.Json;

public class IfElseMethod
extends Action {
    private final String _conditional;
    private final Action[] _actions;
    private final Action[] _elseActions;

    public IfElseMethod(Task parentTask, Json json) {
        super(parentTask, json);
        this._conditional = this._paramsJson.getString("Conditional");
        System.out.println("conditional: " + this._conditional);
        this._actions = super.getActions("Actions");
        System.out.println("if " + this._actions.length + " actions");
        this._elseActions = super.getActions("ElseActions");
        System.out.println("else " + this._actions.length + " actions");
    }

    @Override
    public void execute(TaskRuntime taskRuntime) throws Throwable {
        long start = System.currentTimeMillis();
        try {
            String newConditionalString = TextReplacer.replace(this._conditional, taskRuntime.Scope);
            System.out.println(String.format("newConditionalString: %s", newConditionalString));
            ASTParser expressionParser = new ASTParser(newConditionalString, taskRuntime.Scope);
            ASTNode expressionNode = expressionParser.parse();
            System.out.println("expressionNode: " + expressionNode + "(" + expressionNode.getClass().getName() + ")");
            boolean result = false;
            Object resultObject = expressionNode.evaluate();
            System.out.println("resultObject: " + resultObject + "(" + resultObject.getClass().getName() + ")");
            if (resultObject instanceof Boolean) {
                result = (Boolean)resultObject;
            } else if (resultObject instanceof Integer) {
                result = (Integer)resultObject != 0;
            } else if (resultObject instanceof Double) {
                result = (Double)resultObject != 0.0;
            }
            System.out.println(String.format("expressionNode: %s = %s\r\n", expressionParser.getExpressionString(), String.valueOf(result)));
            if (result) {
                for (Action action : this._actions) {
                    System.out.println("execute action: " + action);
                    action.execute(taskRuntime);
                }
            } else {
                for (Action action : this._elseActions) {
                    System.out.println("execute else action: " + action);
                    action.execute(taskRuntime);
                }
            }
        }
        catch (Exception ex) {
            throw new Exception("Error executing If Conditional: " + this._conditional).initCause(ex);
        }
        long elapsed = System.currentTimeMillis() - start;
        System.out.println("if then elapsed: " + elapsed);
    }
}

