/* global bootbox, Tasker */

TaskerApp.controller('TasksController', function ($scope, $compile, $location, TaskService, DeviceService) {
    var _this = this;
    _this.ShowDebugDevices = false;


    // watch for changes to our $location.url() object.
    $scope.$watch(function () {
        return $location.url();
    }, function (url) {
        if (url) {
            var taskname = $location.search().taskname;
            if (taskname) {
                // find the task object for the given taskname
                var task = TaskService.TaskList.find(function (element) {
                    if (element.Name == taskname) return element;
                });
                if (task && TaskService.SelectedTask != task) {
                    _this.selectTask(task);
                }
            }
            else _this.selectTask(null);

            // var workspaceName = $location.search().workspace;
            // if (undefined != workspaceName && _this.Workspace != workspaceName) {
            //     _this.Workspace = workspaceName;
            //     JnrWebsocket.readFile('/flash/tasker/workspaces/' + workspaceName, _this.configReceived);
            // }
        }
    });



    $scope.$on('workspace.loaded', function (event) {
        var taskName = $location.search().taskname;
        if (taskName) {
            var task = TaskService.TaskList.find(function (element) {
                if (element.Name == taskName) return element;
            });
            if (task) _this.selectTask(task);
        }
    });



    _this.getDeviceProfiles = function () {
        return DeviceService.DeviceList;
    };



    _this.getSNMPDevices = function () {
        return DeviceService.DeviceList.filter(function (element) {
            return 'SNMPDevice' === element.Type;
        });
    };



    _this.getSNMPTypes = function () {
        return ["integer", "string"];
    };



    _this.getModbusDevices = function () {
        return DeviceService.DeviceList.filter(function (element) {
            return 'ModbusDevice' === element.Type;
        });
    };



    _this.projectorCommandsFor = {};
    _this.getProjectorCommandsForDevice = function (deviceGUID) {
        // return DeviceService.ProjectorCommands;

        var deviceCommands = _this.projectorCommandsFor[deviceGUID];
        if (undefined != deviceCommands) {
            return deviceCommands;
        }

        // look up the device based on the GUID
        var projectorDevices = DeviceService.DeviceList.filter(function (element) {
            return element.GUID == deviceGUID;
        });
        if (1 == projectorDevices.length) {
            var deviceType = projectorDevices[0].Params.ProjectorType;
            var deviceTypeCommands = _this.projectorCommandsFor[deviceType];
            if (undefined != deviceTypeCommands) {
                return deviceTypeCommands;
            }

            _this.projectorCommandsFor[deviceGUID] = [];
            _this.projectorCommandsFor[deviceType] = [];

            $.get('/tasker/devices/projectors/' + deviceType + '.json', function (data) {
                data = JSON.parse(data);
                _this.projectorCommandsFor[deviceGUID] = data;
                _this.projectorCommandsFor[deviceType] = data;
                $scope.$apply();
            });
        } return null;
    };



    _this.getArgsForProjectorDeviceCommand = function (deviceGUID, commandType) {
        var deviceCommands = _this.projectorCommandsFor[deviceGUID];
        if (undefined != deviceCommands) {
            var projectorCommands = deviceCommands.filter(function (element) {
                return element.Type == commandType;
            });
            if (1 == projectorCommands.length) {
                return projectorCommands[0].Args;
            } return null;
        } return null;
    };



    _this.soundProcessorCommandsFor = {};
    _this.getSoundProcessorCommandsForDevice = function (deviceGUID) {
        // return DeviceService.SoundProcessorCommands;

        var deviceCommands = _this.soundProcessorCommandsFor[deviceGUID];
        if (undefined != deviceCommands) {
            return deviceCommands;
        }

        // look up the device based on the GUID
        var soundProcessorDevices = DeviceService.DeviceList.filter(function (element) {
            return element.GUID == deviceGUID;
        });
        if (1 == soundProcessorDevices.length) {
            var deviceType = soundProcessorDevices[0].Params.SoundProcessorType;
            var deviceTypeCommands = _this.soundProcessorCommandsFor[deviceType];
            if (undefined != deviceTypeCommands) {
                return deviceTypeCommands;
            }

            _this.soundProcessorCommandsFor[deviceGUID] = [];
            _this.soundProcessorCommandsFor[deviceType] = [];

            $.get('/tasker/devices/soundprocessors/' + deviceType + '.json', function (data) {
                data = JSON.parse(data);
                _this.soundProcessorCommandsFor[deviceGUID] = data;
                _this.soundProcessorCommandsFor[deviceType] = data;
                $scope.$apply();
            });
        } return null;
    };



    _this.getArgsForSoundProcessorDeviceCommand = function (deviceGUID, commandType) {
        var deviceCommands = _this.soundProcessorCommandsFor[deviceGUID];
        if (undefined != deviceCommands) {
            var soundProcessorCommands = deviceCommands.filter(function (element) {
                return element.Type == commandType;
            });
            if (1 == soundProcessorCommands.length) {
                return soundProcessorCommands[0].Args;
            } return null;
        } return null;
    };



    _this.areTasksLoaded = function () {
        return TaskService.TasksLoaded;
    };



    _this.getTasks = function () {
        return TaskService.TaskList;
    };



    _this.selectTask = function (task) {
        var formValid = true;
        if (task) {
            var form = $("#tasks-form");
            form.validate({
                errorPlacement: function (error, element) {
                    console.log(element + ': ' + error);
                }
            });
            formValid = form.valid();
        }

        if (formValid) {
            TaskService.SelectedTask = task;
            if (null != task) $location.search('taskname', task.Name);
            else $location.search('taskname', '');


            $('html, body').animate({
                scrollTop: $('#tasks-form').offset().top - 125
            }, 300);
        } else {
            bootbox.alert({
                className: 'bb-warning',
                title: 'Validation Error',
                message: 'There was an error validating this task.  Please check the fields in red and try again'
            });
        }
    };



    _this.getSelectedTask = function () {
        return TaskService.SelectedTask;
    };



    _this.moveUp = function (task, currentIndex) {
        // remove from current position
        TaskService.TaskList.splice(currentIndex, 1);

        // assign the task to the previous position 
        TaskService.TaskList.splice(currentIndex - 1, 0, task);
    };



    _this.moveDown = function (task, currentIndex) {
        // remove from current position
        TaskService.TaskList.splice(currentIndex, 1);

        // assign the task to the previous position 
        TaskService.TaskList.splice(currentIndex + 1, 0, task);
    };



    _this.addTask = function () {
        if (undefined != _this.addTaskDialog) return;

        _this.addTaskDialog = bootbox.prompt({
            className: 'bb-success',
            title: "What is the name of the new Task?",
            buttons: {
                cancel: {
                    label: 'Cancel',
                    className: 'btn-default'
                },
                confirm: {
                    label: 'Add',
                    className: 'btn-success'
                }
            },
            callback: function (result) {
                if (result) {
                    if (undefined == TaskService.TaskList) TaskService.TaskList = [];
                    var task = new Task(result, true);
                    task.Action = new ControlFunction();
                    TaskService.TaskList.push(task);

                    _this.selectTask(task);

                    $scope.$apply();
                } else return (null == result);
            }
        }).init(function () {
            validate_alphanumeric($(".bootbox-input"));
            confirm_or_submit_on_enter($(".bootbox"));

            var newName = getNextAvailableName(TaskService.TaskList, "New_Task");
            $(".bootbox-input-text").val(newName);
        }).on('hidden.bs.modal', function () {
            _this.addTaskDialog = undefined;
        });
    };



    _this.editTaskName = function (task) {
        if (undefined != _this.editTaskNameDialog) return;

        _this.editTaskNameDialog = bootbox.prompt({
            className: 'bb-success',
            title: "Edit the name of the Task?",
            buttons: {
                cancel: {
                    label: 'Cancel',
                    className: 'btn-default'
                },
                confirm: {
                    label: 'Update',
                    className: 'btn-success'
                }
            },
            value: task.Name,
            callback: function (result) {
                if (result) {
                    task.Name = result;
                    $scope.$apply();
                }
            }
        }).init(function () {
            validate_alphanumeric($(".bootbox-input"));
            confirm_or_submit_on_enter($(".bootbox-input"));
        }).on('hidden.bs.modal', function () {
            _this.editTaskNameDialog = undefined;
        });
    };



    _this.cloneTask = function (task) {
        if (undefined != _this.cloneTaskDialog) return;

        _this.cloningTask = task;

        _this.cloneTaskDialog = bootbox.prompt({
            className: 'bb-success',
            title: "Enter the name of the new Task?",
            buttons: {
                cancel: {
                    label: 'Cancel',
                    className: 'btn-default'
                },
                confirm: {
                    label: 'Update',
                    className: 'btn-success'
                }
            },
            value: task.Name,
            callback: function (result) {
                if (result) {
                    if (undefined == TaskService.TaskList) TaskService.TaskList = [];
                    var task = new Task(result, true);

                    // here we use the stringify method along with a custom replacer that 
                    // will strip out the GUIDs from the current set of actions.  We do 
                    // this so that when teh actions are parsed they will be assigned new 
                    // GUIDs thus making them unique and belonging to the new Task.
                    var newActionCloneString = JSON.stringify(_this.cloningTask.Action, function replacer(key, value) {
                        if ('GUID' === key) return;
                        return value;
                    });
                    var newAction = JSON.parse(newActionCloneString);
                    task.Action = parseAction(newAction);
                    TaskService.TaskList.push(task);

                    _this.selectTask(task);

                    $scope.$apply();
                }
            }
        }).init(function () {
            validate_alphanumeric($(".bootbox-input"));
            confirm_or_submit_on_enter($(".bootbox-input"));
        }).on('hidden.bs.modal', function () {
            _this.cloneTaskDialog = undefined;
        });
    };



    _this.removeTask = function (task) {
        if (undefined != _this.removeTaskDialog) return;

        _this.removeTaskDialog = bootbox.confirm({
            className: 'bb-warning',
            title: "Are you sure?",
            message: "Are you sure you wish to remove the '" + task.Name + "' task?",
            buttons: {
                cancel: {
                    label: 'Cancel',
                    className: 'btn-default'
                },
                confirm: {
                    label: 'Remove',
                    className: 'btn-warning'
                }
            },
            callback: function (result) {
                if (result) {

                    var index = TaskService.TaskList.indexOf(task);
                    if (-1 != index) {
                        TaskService.TaskList.splice(index, 1);
                    }
                    _this.selectTask(null);

                    $scope.$apply();
                }
            }
        }).init(function () {
            confirm_or_submit_on_enter($(".bootbox"));
        }).on('hidden.bs.modal', function () {
            _this.removeTaskDialog = undefined;
        });
    };



    _this.removeAction = function (actions, action) {
        if (undefined !== actions) {
            if (undefined != _this.removeActionDialog) return;

            _this.removeActionDialog = bootbox.confirm({
                className: 'bb-warning',
                title: "Are you sure?",
                message: "Are you sure you wish to remove this Action?",
                buttons: {
                    cancel: {
                        label: 'Cancel',
                        className: 'btn-default'
                    },
                    confirm: {
                        label: 'Remove',
                        className: 'btn-warning'
                    }
                },
                callback: function (result) {
                    if (result) {

                        var index = actions.indexOf(action);
                        if (-1 !== index) {
                            actions.splice(index, 1);
                        }

                        $scope.$apply();
                    }
                }
            }).init(function () {
                confirm_or_submit_on_enter($(".bootbox"));
            }).on('hidden.bs.modal', function () {
                _this.removeActionDialog = undefined;
            });
        }
    };



    _this.cloneAction = function (actions, action) {
        if (undefined !== actions) {
            var newActionCloneString = JSON.stringify(action, function replacer(key, value) {
                if ('GUID' === key) return;
                if ('$$hashKey' === key) return;
                return value;
            });
            var newAction = JSON.parse(newActionCloneString);
            newAction = parseAction(newAction);

            var index = actions.indexOf(action);
            actions.splice(index + 1, 0, newAction);
        }
    };



    _this.removeActionFromTask = function (task, action) {
        if (undefined != _this.editDeviceNameDialog) return;

        _this.removeActionDialog = bootbox.confirm({
            className: 'bb-warning',
            title: "Are you sure?",
            message: "Are you sure you wish to remove the '" + action.Abbrv + "." + action.Method + "' action?",
            buttons: {
                cancel: {
                    label: 'Cancel',
                    className: 'btn-default'
                },
                confirm: {
                    label: 'Remove',
                    className: 'btn-warning'
                }
            },
            callback: function (result) {
                if (result) {

                    var index = task.Actions.indexOf(action);
                    if (-1 != index) {
                        task.Actions.splice(index, 1);
                    }

                    $scope.$apply();
                }
            }
        }).on('hidden.bs.modal', function () {
            _this.removeActionDialog = undefined;
        });
    };



    _this.resetAction = function (action) {
        action.Method = undefined;
    };



    _this.resetActionParams = function (action) {
        action.Params = {};
    };



    _this.executeTask = function (task) {
        JnrWebsocket.postMessage(2010, { Message: 'task.execute', TaskName: task.Name });
    };



    _this.addAction = function (newAction) {
        switch (newAction) {
            // OTHER
            case 'Comment':
                newAction = new Comment("some comment");
                break;

            case 'CommandLine':
                newAction = new CommandLine();
                break;

            case 'Reboot':
                newAction = new Reboot();
                break;

            case 'ExecTask':
                newAction = new ExecTask();
                break;

            case 'CancelTask':
                newAction = new CancelTask();
                break;

            case 'ExecScript':
                newAction = new ExecScript();
                break;

            case 'UserAlert':
                newAction = new UserAlert();
                break;

            case 'FileDelete':
                newAction = new FileDelete();
                break;

            case 'FilePrepend':
                newAction = new FilePrepend();
                break;

            case 'FileMove':
                newAction = new FileMove();
                break;

            case 'FileCopy':
                newAction = new FileCopy();
                break;

            case 'SetVariable':
                newAction = new SetVariable();
                break;

            case 'RegistryWrite':
                newAction = new RegistryWrite();
                break;


            // RELAY OUTPUTS
            case 'CloseRelay':
                newAction = new CloseRelay();
                break;

            case 'OpenRelay':
                newAction = new OpenRelay();
                break;

            case 'SetRelayState':
                newAction = new SetRelayState();
                break;

            case 'PulseRelay':
                newAction = new PulseRelay();
                break;

            case 'SetBlock':
                newAction = new SetBlock();
                break;

            case 'PulseBlock':
                newAction = new PulseBlock();
                break;

            case 'RoutResetUsageMeter':
                newAction = new RoutResetUsageMeter();
                break;


            // DIGITAL INPUT ACTIONS
            case 'SoftInvert':
                newAction = new DinSoftInvert();
                break;

            case 'DinSetState':
                newAction = new DinSetState();
                break;

            case 'SetCounter':
                newAction = new DinSetCounter();
                break;

            case 'DinResetUsageMeter':
                newAction = new DinResetUsageMeter();
                break;

            case 'DinClearLatch':
                newAction = new DinClearLatch();
                break;

            case 'DinSoftPulse':
                newAction = new DinSoftPulse();
                break;


            // ANALOG OUTPUT
            case 'Set10vPercent':
                newAction = new Set10vPercent();
                break;

            case 'Set10vVoltage':
                newAction = new Set10vVoltage();
                break;

            case 'Fade10vPercentage':
                newAction = new Fade10vPercentage();
                break;

            case 'Fade10vVoltage':
                newAction = new Fade10vVoltage();
                break;

            case 'Set420maPercent':
                newAction = new Set420maPercent();
                break;

            case 'Set420maAmps':
                newAction = new Set420maAmps();
                break;


            // CONTROL PANEL
            case 'SetLed':
                newAction = new SetLed();
                break;

            case 'PlayAlarm':
                newAction = new PlayAlarm();
                break;

            case 'SilenceAlarm':
                newAction = new SilenceAlarm();
                break;

            case 'OnSwitchTrigger':
                newAction = new OnSwitchTrigger();
                break;

            case 'OnMultiSwitchTrigger':
                newAction = new OnMultiSwitchTrigger();
                break;



            // Timing
            case 'SleepAction':
                newAction = new SleepAction();
                break;



            // Control Structures
            case 'ForLoop':
                newAction = new ForLoop();
                break;

            case 'IfBlock':
                newAction = new IfBlock();
                break;

            case 'IfElseBlock':
                newAction = new IfElseBlock();
                break;

            case 'WhileLoop':
                newAction = new WhileLoop();
                break;



            // LIGHTING
            case 'SetLEDChannel':
                newAction = new SetLEDChannel();
                break;

            case 'SetLEDRGB':
                newAction = new SetLEDRGB();
                break;

            case 'FadeLEDChannel':
                newAction = new FadeLEDChannel();
                break;

            case 'FadeLEDRGB':
                newAction = new FadeLEDRGB();
                break;


            // LOGGING
            case 'LogEntry':
                newAction = new LogEntry();
                break;

            case 'LogProfile':
                newAction = new LogProfile();
                break;


            // NETWORK
            case 'ProjectorSend':
                newAction = new ProjectorSend();
                break;

            case 'SoundProcessorSend':
                newAction = new SoundProcessorSend();
                break;

            case 'TcpSend':
                newAction = new TcpSend();
                break;

            case 'SerialSend':
                newAction = new SerialSend();
                break;

            case 'TcpRecv':
                newAction = new TcpRecv();
                break;

            case 'TcpClose':
                newAction = new TcpClose();
                break;

            case 'EmailEntry':
                newAction = new EmailEntry();
                break;

            case 'EmailProfile':
                newAction = new EmailProfile();
                break;

            case 'SNMPTrap':
                newAction = new SNMPTrap();
                break;

            case 'SNMPSet':
                newAction = new SNMPSet();
                break;

            case 'MQTTPublish':
                newAction = new MQTTPublish();
                break;

            case 'HTTPGet':
                newAction = new HTTPGet();
                break;

            case 'HTTPPost':
                newAction = new HTTPPost();
                break;
        }

        // _this.selectedActionsBlock.addAction(newAction);
        _this.selectedActionsBlock.push(newAction);

        _this.addActionDialog.modal('hide');
        _this.ShowDebugDevices = false;
    };


    _this.showAddToActionsDialog = function (actionsBlock, $event) {
        if (undefined != _this.addActionDialog) return;

        var template = '<div ng-include="\'tasks/new-actions-3.html\'"></div>';
        var linkFn = $compile(template);
        var html = linkFn($scope);

        _this.selectedActionsBlock = actionsBlock;
        _this.addActionDialog = bootbox.dialog({
            // className: 'fullscreen bb-primary',
            className: 'bb-primary',
            title: "Add Action <a href=\"/tasker/help/#?blockId=task_actions\" target=\"blank\" style=\"color: #ccc;\">" +
                "<i class=\"fa fa-question-circle\" aria-hidden=\"true\"></i>" +
                "</a>",
            message: html,
            // size: 'large',
            onEscape: function () {
                _this.addActionDialog.modal('hide');
                _this.ShowDebugDevices = false;
            }
        });
        // init MUST not be chained as it isnt instantiated yet!
        _this.addActionDialog.init(function () {
            $compile(_this.addActionDialog.contents())($scope);
        }).on('hidden.bs.modal', function () {
            _this.addActionDialog = undefined;
        });
    };



    _this.showIfHelp = function () {
        if (undefined != _this.showHelpDialog) return;

        _this.showHelpDialog = bootbox.dialog({
            className: 'bb-primary',
            title: "If/Then Help",
            message: '<h3>Available conditionals</h3>\r\n' +
                '<p>\r\n' +
                '  <h4>Internal I/O</h4>\r\n' +
                '  <code>din[#].state == 1</code><br>\r\n' +
                '  <code>rout[#].state == 1</code><br>\r\n' +
                '  <h4>Temperature and Environmental I/O</h4>\r\n' +
                '  <code>temp[#].f >= 75</code> or <code>temp[#].fahrenheit >= 75</code><br>\r\n' +
                '  <code>temp[#].c >= 20</code> or <code>temp[#].celsius >= 20</code><br>\r\n' +
                '  <code>env[#].f >= 75</code> or <code>env[#].fahrenheit >= 75</code><br>\r\n' +
                '  <code>env[#].c >= 20</code> or <code>env[#].celsius >= 20</code><br>\r\n' +
                '  <code>env[#].humidity >= 80</code>\r\n' +
                '  <h4>Validate Days of the Week</h4>\r\n' +
                '  <code>date.isDay(montuewedthufri)</code><br>\r\n' +
                '  <code>date.isDay(satsun)</code><br>\r\n' +
                '  <h4>Validate Time of Day</h4>\r\n' +
                '  <code>time.before(HH:MM)</code><br>\r\n' +
                '  <code>time.after(HH:MM)</code><br>\r\n' +
                '</p>',
            backdrop: true,
            onEscape: function () {
                this.modal('hide');
            }
        });
    };
});



/*
   SERVICE
*/
TaskerApp.service('TaskService', function ($rootScope, DeviceService) {
    var _this = this;
    _this.TaskList = [];
    _this.SelectedTask = null;
    _this.TasksLoaded = false;



    _this.load = function (taskListJson) {
        if (undefined == taskListJson) taskListJson = [];

        try {
            parseTaskList(taskListJson);
        } catch (err) {
            console.error(err);
        }

        _this.SelectedTask = null;
        _this.TasksLoaded = true;

        return _this.TaskList;
    };



    function parseTaskList(taskArray) {
        // empty our array of tasks
        _this.TaskList = [];

        taskArray.forEach(function (taskJson) {
            if (undefined == taskJson.Enabled) taskJson.Enabled = true;
            var task = new Task(taskJson.Name, taskJson.Enabled);

            // parse the task base action
            var action = parseAction(taskJson.Action);
            if (taskJson.GUID) {
                task.GUID = taskJson.GUID;
            }
            task.Action = action;
            // successful task.  push it to our array of tasks
            _this.TaskList.push(task);
        });
    }



    _this.isValid = true;
    _this.validate = function () {
        var form = $("#tasks-form");
        if (0 < form.length) {
            form.validate({
                ignore: ".ignore",
                errorPlacement: function (error, element) { },
                invalidHandler: function (event, validator) {
                    // 'this' refers to the form
                    var errors = validator.numberOfInvalids();
                    if (errors) {
                        var message = errors == 1
                            ? 'You missed 1 field. It has been highlighted'
                            : 'You missed ' + errors + ' fields. They have been highlighted';
                        $("div.error span").html(message);
                        $("div.error").show();
                    } else {
                        $("div.error").hide();
                    }
                }
            });
            _this.isValid = form.valid();
            // if (!_this.isValid) {
            //     bootbox.alert({
            //         className: 'bb-warning',
            //         title: 'Validation Error',
            //         message: 'There was an error validating this task.  Please check the fields in red and try again'
            //     });
            // }
        }
        return _this.isValid;
    };
});







TaskerApp.directive('actionBlock', function ($compile) {
    return {
        restrict: 'E', // element
        scope: {
            action: '=',
            parent: '=',
            actions: '=',
            controller: '='
        },
        link: function (scope, element, attrs) {
            var html = '<ul droppable action="action" style="min-height: 12px; padding:8px;">\r\n' +
                '<li ng-repeat="childAction in actions" draggable action="childAction" index="$index" style="list-style:none; padding-bottom:0;">\r\n' +
                '  <div action-div action="childAction" level="0" parent="action" actions="actions" controller="controller" style="min-height: 42px; padding: 4px;"></div>\r\n' +
                '</li>\r\n' +
                '<li draggable ng-if="0 == actions.length" class="add-action" style="list-style:none; padding-bottom:0;">Drag an Action or click Add Action to add an Action to this Task</li>\r\n' +
                '</ul>\r\n' +
                '<a href="javascript: void(0)" ng-click="controller.showAddToActionsDialog(actions, $event)" class="text-success">\r\n' +
                '  <i class="fa fa-plus" aria-hidden="true"></i> Add Action</a>';

            element.html(html).show();
            $compile(element.contents())(scope);
        }
    };
});



TaskerApp.directive('actionDiv', function ($compile) {
    return {
        restrict: 'A', // attribute
        scope: {
            action: '=',
            level: '=',
            parent: '=',
            controller: '=',
            actions: '='
        },
        link: function (scope, element, attrs) {
            scope.index++;

            var html = '<i class="fa fa-bars" style="margin-right: 12px" data-toggle="tooltip" title="Drag and Drop"></i>\r\n' +
                '<a href="javascript: void(0)" ng-click="controller.cloneAction(actions, action)" class="text-primary" data-toggle="tooltip" title="Clone this Action.  The new Action will be placed below."><i class="fa fa-clone" aria-hidden="true" style="margin-right: 12px"></i></a> \r\n' +
                '<a href="javascript: void(0)" ng-click="controller.removeAction(actions, action)" class="text-danger" data-toggle="tooltip" title="Remove this Action"><i class="fa fa-trash" aria-hidden="true" style="margin-right: 12px"></i></a> \r\n' +
                '<span action-edit action="action" controller="controller" class="form-inline"></span>\r\n';

            html += scope.action.getAdditionalHtml();

            element.html(html).show();
            $compile(element.contents())(scope);
        }
    };
});



TaskerApp.directive('actionEdit', function ($compile) {
    return {
        restrict: 'A', // attribute
        scope: {
            action: '=',
            controller: '='
        },
        link: function ($scope, element, attrs) {
            var template = $scope.action.editTemplate();
            element.html(template).show();
            $compile(element.contents())($scope);

            $('[data-toggle="tooltip"]').tooltip({ delay: 500 });

            alphanumeric();
        }
    };
});