/*
 * Decompiled with CFR 0.152.
 */
package com.integ.tasker.tasks.actions;

import com.integ.tasker.tasks.Task;
import com.integ.tasker.tasks.actions.Action;
import com.integ.tasker.tasks.actions.analog.AnalogControlFactory;
import com.integ.tasker.tasks.actions.controlpanel.ControlPanelFactory;
import com.integ.tasker.tasks.actions.controlstructures.ControlStructureFactory;
import com.integ.tasker.tasks.actions.dimmercontrol.DimmerControlFactory;
import com.integ.tasker.tasks.actions.logger.LoggerFactory;
import com.integ.tasker.tasks.actions.network.NetworkFactory;
import com.integ.tasker.tasks.actions.other.OtherFactory;
import com.integ.tasker.tasks.actions.relayoutputs.RelayControlFactory;
import com.integ.tasker.tasks.actions.timing.TimingFactory;
import java.util.Json;

public class ActionFactory {
    public static Action getActionClass(Task parentTask, Json json) throws Throwable {
        String typeString;
        switch (typeString = json.getString("Type")) {
            case "Control": {
                return ControlStructureFactory.getActionMethod(parentTask, json);
            }
            case "RelayControl": {
                return RelayControlFactory.getActionMethod(parentTask, json);
            }
            case "AnalogControl": {
                return AnalogControlFactory.getActionMethod(parentTask, json);
            }
            case "ControlPanel": {
                return ControlPanelFactory.getActionMethod(parentTask, json);
            }
            case "DimmerControl": {
                return DimmerControlFactory.getActionMethod(parentTask, json);
            }
            case "Timing": {
                return TimingFactory.getActionMethod(parentTask, json);
            }
            case "Network": {
                return NetworkFactory.getActionMethod(parentTask, json);
            }
            case "Logger": {
                return LoggerFactory.getActionMethod(parentTask, json);
            }
            case "Other": {
                return OtherFactory.getOtherMethod(parentTask, json);
            }
        }
        throw new Exception(String.format("Unknown Type: %s in %s", typeString, json.toString()));
    }
}

