/*
 * Decompiled with CFR 0.152.
 */
package com.integ.scripting.nodes;

import com.integ.scripting.nodes.AbstractNode;
import com.integ.tasker.lexer.Token;
import com.integ.tasker.tasks.Scope;

public class LogicalNode
extends AbstractNode {
    public Token Operator;
    public AbstractNode Left;
    public AbstractNode Right;

    public LogicalNode(Token operator, AbstractNode left, AbstractNode right) {
        this.Operator = operator;
        this.Left = left;
        this.Right = right;
    }

    public String toString() {
        return String.format("%s %s %s", this.Left.toString(), this.Operator.content, this.Right.toString());
    }

    @Override
    public Object execute(Scope scope) {
        boolean _debug_ = scope.isDebug();
        if (_debug_) {
            System.out.println("Left = " + this.Left);
        }
        Object leftResultObject = this.Left.execute(scope);
        if (_debug_) {
            System.out.println("leftResultObject = " + leftResultObject);
        }
        if (_debug_ && null != leftResultObject) {
            System.out.println("leftResultObject = " + leftResultObject + " " + leftResultObject.getClass());
        }
        if (_debug_) {
            System.out.println("Right = " + this.Right);
        }
        Object rightResultObject = this.Right.execute(scope);
        if (_debug_) {
            System.out.println("rightResultObject = " + rightResultObject);
        }
        if (_debug_ && null != rightResultObject) {
            System.out.println("rightResultObject = " + rightResultObject + " " + rightResultObject.getClass());
        }
        if (null == leftResultObject || null == rightResultObject) {
            return true;
        }
        try {
            switch (this.Operator.type) {
                case 11: {
                    if (leftResultObject.getClass() != rightResultObject.getClass()) {
                        System.out.println(leftResultObject.getClass() + " does not equal " + rightResultObject.getClass());
                        if (leftResultObject instanceof Number && rightResultObject instanceof Boolean) {
                            leftResultObject = 0.0 != ((Number)leftResultObject).doubleValue();
                        } else if (rightResultObject instanceof Number && leftResultObject instanceof Boolean) {
                            rightResultObject = 0.0 != ((Number)rightResultObject).doubleValue();
                        }
                    }
                    return String.valueOf(leftResultObject).equals(String.valueOf(rightResultObject));
                }
                case 12: {
                    if (leftResultObject.getClass() != rightResultObject.getClass()) {
                        System.out.println(leftResultObject.getClass() + " does not equal " + rightResultObject.getClass());
                        if (leftResultObject instanceof Number && rightResultObject instanceof Boolean) {
                            leftResultObject = 0.0 != ((Number)leftResultObject).doubleValue();
                        } else if (rightResultObject instanceof Number && leftResultObject instanceof Boolean) {
                            rightResultObject = 0.0 != ((Number)rightResultObject).doubleValue();
                        }
                    }
                    return !String.valueOf(leftResultObject).equals(String.valueOf(rightResultObject));
                }
                case 60: {
                    if (!(leftResultObject instanceof Number) || !(rightResultObject instanceof Number)) {
                        return false;
                    }
                    return ((Number)leftResultObject).doubleValue() < ((Number)rightResultObject).doubleValue();
                }
                case 14: {
                    if (!(leftResultObject instanceof Number) || !(rightResultObject instanceof Number)) {
                        return false;
                    }
                    return ((Number)leftResultObject).doubleValue() <= ((Number)rightResultObject).doubleValue();
                }
                case 62: {
                    if (!(leftResultObject instanceof Number) || !(rightResultObject instanceof Number)) {
                        return false;
                    }
                    return ((Number)leftResultObject).doubleValue() > ((Number)rightResultObject).doubleValue();
                }
                case 13: {
                    if (!(leftResultObject instanceof Number) || !(rightResultObject instanceof Number)) {
                        return false;
                    }
                    return ((Number)leftResultObject).doubleValue() >= ((Number)rightResultObject).doubleValue();
                }
                case 10: {
                    if (!(leftResultObject instanceof Boolean) || !(rightResultObject instanceof Boolean)) {
                        return false;
                    }
                    return (Boolean)leftResultObject != false && (Boolean)rightResultObject != false;
                }
                case 9: {
                    if (!(leftResultObject instanceof Boolean) || !(rightResultObject instanceof Boolean)) {
                        return false;
                    }
                    return (Boolean)leftResultObject != false || (Boolean)rightResultObject != false;
                }
            }
        }
        catch (ClassCastException ex) {
            throw new RuntimeException(String.format("%s is not the same type as %s", leftResultObject.getClass(), rightResultObject.getClass()), ex);
        }
        throw new RuntimeException("Invalid Logical Operator Type: " + this.Operator);
    }
}

