/*
 * Decompiled with CFR 0.152.
 */
package com.integ.tasker.devices;

import com.integ.tasker.devices.DeviceProfile;
import com.integ.tasker.devices.UDPServerDevice;
import com.integ.tasker.devices.osc.OSCMessage;
import com.integ.tasker.tasks.Task;
import com.integ.tasker.tasks.TaskCollection;
import com.integ.tasker.web.messages.ErrorMessage;
import com.integpg.janoslib.messagepump.MessagePumpEngine;
import com.integpg.janoslib.net.udp.UdpConnectionListener;
import com.integpg.janoslib.net.udp.UdpServerEvent;
import com.integpg.janoslib.utils.HexUtils;
import java.util.Json;

public class OSCServerDevice
extends DeviceProfile
implements UdpConnectionListener {
    private String _protocol;
    private int _port;
    private UDPServerDevice _udpServerDevice = null;

    public OSCServerDevice(Json json) {
        super(json);
        try {
            Json paramsJson = (Json)json.get("Params");
            this._protocol = paramsJson.getString("Protocol");
            this._port = paramsJson.getInt("Port");
            LOG.info(String.format("OSC Server Device: procotol: %s, port: %d", this._protocol, this._port));
            this._udpServerDevice = new UDPServerDevice(json);
            this._udpServerDevice.setListener(this);
        }
        catch (Throwable ex) {
            Throwable throwable = new Exception("unable to load " + this.Name).initCause(ex);
            LOG.error(throwable);
            ErrorMessage message = new ErrorMessage(throwable);
            MessagePumpEngine.postMessage(message.build());
        }
    }

    public int getPort() {
        return this._port;
    }

    @Override
    public void processMessage(UdpServerEvent udpServerEvent) {
        try {
            byte[] messageBytes = udpServerEvent.getPacket().getData();
            System.out.println("received OSC" + HexUtils.hexDump(messageBytes));
            OSCMessage receivedMessage = new OSCMessage(messageBytes);
            LOG.info(receivedMessage.getAddress());
            if ("/task/execute".equalsIgnoreCase(receivedMessage.getAddress())) {
                String taskName = (String)receivedMessage.getValueAt(0);
                LOG.info("execute task: " + taskName);
                Task task = TaskCollection.GLOBAL.getByTaskName(taskName);
                if (null != task) {
                    try {
                        task.execute("OSC Server");
                    }
                    catch (Throwable ex) {
                        ex.printStackTrace();
                    }
                }
            }
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }
}

