/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.janoslib.externalio;

import com.integpg.janoslib.externalio.ExternalDeviceOrder;
import com.integpg.janoslib.externalio.ExternalModule;
import com.integpg.system.ArrayUtils;
import com.integpg.system.JANOS;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.Date;

public class TypeFD
extends ExternalModule {
    private final byte[] _outBytes = new byte[8];
    public int[] RawOut = new int[2];
    public int[] RawIn = new int[4];
    private DecimalFormat df = new DecimalFormat("0.000");

    public static TypeFD[] getDeviceArray() {
        return ExternalDeviceOrder.getTypeFDArray();
    }

    public static TypeFD getByIndex(int index) {
        TypeFD[] deviceArray = TypeFD.getDeviceArray();
        return deviceArray[index];
    }

    TypeFD(long address) {
        super(address, -1, "TypeFD");
    }

    TypeFD(long address, int index) {
        super(address, index, "TypeFD");
    }

    @Override
    public void read() throws IOException {
        int channel;
        this._dataBlock = JANOS.readDeviceBlock((long)this.Address);
        if (this._dataBlock.length != 12) {
            throw new IOException("Unable to read " + this.AddressString);
        }
        this.LastReadTime = System.currentTimeMillis();
        for (channel = 0; channel < 4; ++channel) {
            this.RawIn[channel] = ArrayUtils.getShort((byte[])this._dataBlock, (int)(channel * 2)) & 0xFFFF;
        }
        for (channel = 0; channel < 2; ++channel) {
            this.RawOut[channel] = ArrayUtils.getShort((byte[])this._dataBlock, (int)(channel * 2 + 8)) & 0xFFFF;
        }
    }

    public void setChannelPercentage(int channel, double percent) {
        if (percent >= 0.0) {
            int raw = (int)(65535.0 * (percent / 100.0));
            ArrayUtils.setShort((byte[])this._outBytes, (int)(channel * 2), (short)((short)raw));
            ArrayUtils.setShort((byte[])this._outBytes, (int)(channel * 2 + 4), (short)0);
            System.out.println("set raw: " + raw);
        }
    }

    public void setChannelVoltage(int channel, double voltage) {
        String channelBaseString = "Externals/" + this.AddressString + "/Aout" + channel;
        double min = JANOS.getRegistryDouble((String)(channelBaseString + "/Min"), (double)0.0);
        double max = JANOS.getRegistryDouble((String)(channelBaseString + "/Max"), (double)100.0);
        double targetDelta = voltage - min;
        double totalDelta = max - min;
        double percentage = targetDelta / totalDelta;
        this.setChannelPercentage(channel, percentage * 100.0);
    }

    public void setChannel(int channel, int value) {
        if (value >= 0) {
            ArrayUtils.setShort((byte[])this._outBytes, (int)(channel * 2), (short)((short)value));
            ArrayUtils.setShort((byte[])this._outBytes, (int)(channel * 2 + 4), (short)0);
        }
    }

    public void fadeChannelPercentage(int channel, double percent, int duration) {
        int raw = (int)(65535.0 * (percent / 100.0));
        ArrayUtils.setShort((byte[])this._outBytes, (int)(channel * 2), (short)((short)raw));
        ArrayUtils.setShort((byte[])this._outBytes, (int)(channel * 2 + 4), (short)((short)duration));
    }

    public void fadeChannelVoltage(int channel, double voltage, int duration) {
        String channelBaseString = "Externals/" + this.AddressString + "/Aout" + channel;
        double min = JANOS.getRegistryDouble((String)(channelBaseString + "/Min"), (double)0.0);
        double max = JANOS.getRegistryDouble((String)(channelBaseString + "/Max"), (double)100.0);
        double targetDelta = voltage - min;
        double totalDelta = max - min;
        double percentage = targetDelta / totalDelta;
        int raw = (int)(65535.0 * (percentage / 100.0));
        ArrayUtils.setShort((byte[])this._outBytes, (int)(channel * 2), (short)((short)raw));
        ArrayUtils.setShort((byte[])this._outBytes, (int)(channel * 2 + 4), (short)((short)duration));
    }

    public int getRawIn(int channel) {
        return this.RawIn[channel - 1];
    }

    public double getPercentageInput(int channel) {
        return this.getPercent(this.RawIn[channel - 1]);
    }

    public double getScaledInput(int channel) {
        String channelBaseString = "Externals/" + this.AddressString + "/Ain" + channel;
        double min = JANOS.getRegistryDouble((String)(channelBaseString + "/Min"), (double)-10.0);
        double max = JANOS.getRegistryDouble((String)(channelBaseString + "/Max"), (double)10.0);
        double value = this.scaleValue(this.RawIn[channel - 1], min, max);
        return value;
    }

    public int getRawOut(int channel) {
        return this.RawOut[channel - 1];
    }

    public double getPercentageOutput(int channel) {
        return this.getPercent(this.RawOut[channel - 1]);
    }

    public double getScaledOutput(int channel) {
        String channelBaseString = "Externals/" + this.AddressString + "/Aout" + channel;
        double min = JANOS.getRegistryDouble((String)(channelBaseString + "/Min"), (double)0.0);
        double max = JANOS.getRegistryDouble((String)(channelBaseString + "/Max"), (double)100.0);
        double value = this.scaleValue(this.RawOut[channel - 1], min, max);
        return value;
    }

    public String getInputUnits(int channel) {
        String channelBaseString = "Externals/" + this.AddressString + "/Ain" + channel;
        return JANOS.getRegistryString((String)(channelBaseString + "/Units"), (String)"ma");
    }

    public String getOutputUnits(int channel) {
        String channelBaseString = "Externals/" + this.AddressString + "/Aout" + channel;
        return JANOS.getRegistryString((String)(channelBaseString + "/Units"), (String)"ma");
    }

    @Override
    public void commit() throws IOException {
        JANOS.writeDeviceBlock((long)this.Address, (byte[])this._outBytes);
    }

    @Override
    public void printValues() {
        int channel;
        System.out.println("Read " + this.AddressString + " @ " + new Date(this.LastReadTime));
        for (channel = 0; channel < 4; ++channel) {
            System.out.println("In " + (channel + 1) + ": " + this.RawIn[channel] + "   " + this.getScaledInput(channel + 1));
        }
        for (channel = 0; channel < 2; ++channel) {
            System.out.println("Out " + (channel + 1) + ": " + this.RawIn[channel] + "   " + this.getScaledOutput(channel + 1));
        }
    }

    public static Object get(int channel, String fieldName) throws IOException {
        try {
            int index = -1;
            if (fieldName.endsWith("out")) {
                index = channel / 2 + 1;
            } else if (fieldName.endsWith("in")) {
                index = channel / 4 + 1;
            }
            TypeFD device = TypeFD.getByIndex(index);
            if (null != device) {
                device.read();
                return device.get(fieldName);
            }
            throw new RuntimeException("Ten Volt Module not present for index " + index);
        }
        catch (IOException ex) {
            throw new RuntimeException("Error getting value for TypeFD." + fieldName, ex);
        }
    }

    @Override
    public Object get(String fieldName) {
        int channel = 1;
        int underscorePos = fieldName.indexOf("_");
        if (-1 != underscorePos) {
            channel = Integer.parseInt(fieldName.substring(underscorePos + 1));
            fieldName = fieldName.substring(0, underscorePos);
        }
        if ("rawin".equalsIgnoreCase(fieldName)) {
            return this.RawIn[channel - 1];
        }
        if ("scaledin".equalsIgnoreCase(fieldName)) {
            return this.getScaledInput(channel);
        }
        if ("descin".equalsIgnoreCase(fieldName)) {
            String registryKeyString = String.format("externals/%s/ain%d/desc", this.AddressString, channel);
            return JANOS.getRegistryString((String)registryKeyString, (String)("Channel " + channel));
        }
        if ("unitsin".equalsIgnoreCase(fieldName)) {
            String registryKeyString = String.format("externals/%s/ain%d/units", this.AddressString, channel);
            return JANOS.getRegistryString((String)registryKeyString, (String)"v");
        }
        if ("rawout".equalsIgnoreCase(fieldName)) {
            return this.RawOut[channel - 1];
        }
        if ("scaledout".equalsIgnoreCase(fieldName)) {
            return this.getScaledOutput(channel);
        }
        if ("descout".equalsIgnoreCase(fieldName)) {
            String registryKeyString = String.format("externals/%s/aout%d/desc", this.AddressString, channel);
            return JANOS.getRegistryString((String)registryKeyString, (String)("Channel " + channel));
        }
        if ("unitsout".equalsIgnoreCase(fieldName)) {
            String registryKeyString = String.format("externals/%s/aout%d/units", this.AddressString, channel);
            return JANOS.getRegistryString((String)registryKeyString, (String)"%");
        }
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

