/*
 * Decompiled with CFR 0.152.
 */
package com.integ.tasker.loggers;

import com.integ.tasker.loggers.LogProfile;
import com.integ.tasker.loggers.LogProfilesCollection;
import com.integ.tasker.workspaces.WorkspaceFile;
import com.integpg.janoslib.logger.FileLog;
import com.integpg.janoslib.logger.LogOptions;
import com.integpg.janoslib.logger.LogTypes;
import com.integpg.janoslib.logger.Logger;
import com.integpg.janoslib.system.Application;
import java.util.Json;

public class LoggerConfiguration {
    private static final Logger LOG = FileLog.getLog(new LogOptions(Application.getAppName() + "_loggers.log").setLogType(LogTypes.HalfBak));
    private final WorkspaceFile _workspaceConfigurationFile;
    private final LogProfilesCollection _logProfilesCollection = new LogProfilesCollection();

    public LoggerConfiguration(WorkspaceFile workspaceConfigurationFile) {
        this._workspaceConfigurationFile = workspaceConfigurationFile;
    }

    public LogProfilesCollection getLogProfilesCollection() {
        return this._logProfilesCollection;
    }

    public void loadConfiguration(Json[] taskListJsonArray) throws Throwable {
        if (null == taskListJsonArray || 0 == taskListJsonArray.length) {
            return;
        }
        for (Json loggerJson : taskListJsonArray) {
            LOG.info("loggerJson: " + loggerJson);
        }
        this._logProfilesCollection.clear();
        for (Json loggerJson : taskListJsonArray) {
            LogProfile logProfile = new LogProfile(loggerJson);
            this._logProfilesCollection.put(logProfile.Name, logProfile);
        }
    }
}

