/*
 * Decompiled with CFR 0.152.
 */
package com.integ.tasker.schedules.rules;

import com.integ.tasker.schedules.Schedule;
import com.integ.tasker.schedules.rules.OnBootRule;
import com.integ.tasker.schedules.rules.ScheduleRule;
import com.integ.tasker.schedules.rules.ScheduleRuleBase;
import com.integ.tasker.schedules.rules.SunriseRule;
import com.integ.tasker.schedules.rules.SunsetRule;
import com.integ.tasker.web.messages.ErrorMessage;
import com.integpg.janoslib.messagepump.MessagePumpEngine;
import java.util.Json;

public class ScheduleRuleFactory {
    public static ScheduleRuleBase getRule(Schedule schedule, Json json) {
        try {
            Schedule.LOG.info("loading Rule from " + json);
            String scheduleType = json.getString("ScheduleType");
            System.out.println("scheduleType: " + scheduleType);
            switch (scheduleType) {
                case "Schedule": {
                    return new ScheduleRule(schedule, json);
                }
                case "Sunrise": {
                    return new SunriseRule();
                }
                case "Sunset": {
                    return new SunsetRule();
                }
                case "On Boot": {
                    return new OnBootRule();
                }
            }
        }
        catch (Throwable ex) {
            Throwable throwable = new Exception("unable to load rule: " + json).initCause(ex);
            Schedule.LOG.error(throwable);
            ErrorMessage message = new ErrorMessage(throwable);
            MessagePumpEngine.postMessage(message.build());
        }
        return null;
    }
}

