/*
 * Decompiled with CFR 0.152.
 */
package com.integ.scripting.objects;

import com.integ.scripting.ExpressionEngine;
import com.integ.scripting.exceptions.DeviceNotPresentException;
import com.integ.scripting.exceptions.ScriptParserException;
import com.integ.scripting.exceptions.UnexpectedTokenException;
import com.integ.scripting.nodes.AbstractNode;
import com.integ.scripting.objects.AbstractObjectCall;
import com.integ.tasker.tasks.Scope;
import com.integpg.janoslib.externalio.TypeFE;
import com.integpg.janoslib.logging.AppLog;
import com.integpg.system.JANOS;
import java.io.IOException;
import java.text.DecimalFormat;

public class FourTwentyInputObject
extends AbstractObjectCall {
    private static final DecimalFormat FORMAT = new DecimalFormat("0.00");
    private static final int CHANNELS_PER_MODULE = 4;
    private static final int ALLOWED_RETRIES = 2;
    private static final int MAX_FAILED_READS = 6;
    private AbstractNode _channelNode;
    private int _failedReadCount = 0;

    @Override
    public AbstractNode parse(ExpressionEngine parser) throws ScriptParserException {
        try {
            if (!parser.nextToken().checkType(91)) {
                throw new UnexpectedTokenException("[", parser.currentToken());
            }
            parser.nextToken();
            if (!parser.currentToken().checkType(3) && !parser.currentToken().checkType(0)) {
                throw new UnexpectedTokenException("NUMBER | IDENTIFIER", parser.currentToken());
            }
            this._channelNode = parser.getObject();
            if (!parser.nextToken().checkType(93)) {
                throw new UnexpectedTokenException("]", parser.currentToken());
            }
            if (!parser.nextToken().checkType(46)) {
                throw new UnexpectedTokenException(".", parser.currentToken());
            }
            if (!parser.nextToken().checkType(0)) {
                throw new UnexpectedTokenException("FIELD NAME", parser.currentToken());
            }
            this._fieldOrMethodName = parser.currentToken().content;
        }
        catch (Exception ex) {
            throw new ScriptParserException("unable to process four twenty input object", ex);
        }
        return this;
    }

    @Override
    public Object execute(Scope scope) {
        int channel = (Integer)this._channelNode.execute(scope);
        return FourTwentyInputObject.read(channel, this._fieldOrMethodName);
    }

    public static Object read(int channel, String fieldName) {
        int moduleIndex = (channel - 1) / 4;
        TypeFE typeFe = TypeFE.getByIndex(moduleIndex);
        if (null != typeFe) {
            String presentDevicesString = JANOS.getRegistryString((String)"externals/$present", (String)"");
            if (!presentDevicesString.contains(typeFe.AddressString)) {
                throw new DeviceNotPresentException(String.format("TypeFE_%d is not present", moduleIndex + 1));
            }
            int retryCount = 0;
            while (true) {
                if (0 > retryCount) {
                    AppLog.error(String.format("retrying read for 4-20ma %s for input channel %d", fieldName, channel));
                }
                try {
                    typeFe.read();
                    int localChannel = (channel - 1) % 4 + 1;
                    fieldName = String.format("%sin_%d", fieldName, localChannel);
                    Object value = typeFe.get(fieldName);
                    return value;
                }
                catch (IOException ex) {
                    AppLog.error(String.format("error getting 4-20ma %s for input channel %d", fieldName, channel), ex);
                    if (2 > retryCount++) continue;
                }
                break;
            }
        } else {
            throw new DeviceNotPresentException(String.format("TypeFE_%d is not present", moduleIndex + 1));
        }
        return Double.NaN;
    }
}

