/*
 * Decompiled with CFR 0.152.
 */
package com.integ.tasker.tasks;

import java.util.Enumeration;
import java.util.Hashtable;

public class Scope {
    private static final Scope GLOBAL = new Scope();
    private final Hashtable<String, Object> _varaibles = new Hashtable();
    boolean _debug_;

    public static Scope getGlobal() {
        return GLOBAL;
    }

    public boolean isDebug() {
        return this._debug_;
    }

    public void setDebug(boolean debug) {
        this._debug_ = debug;
    }

    public void setVariable(String variable, Object value) {
        if ("_debug_".equalsIgnoreCase(variable)) {
            this._debug_ = (Boolean)value;
        } else {
            boolean isGlobal = variable.startsWith("$$");
            if (GLOBAL != this && isGlobal) {
                GLOBAL.setVariable(variable, value);
            }
            if (this._debug_) {
                System.out.println(String.format("   %s - set %s to %s", this.toString(), variable, value.toString()));
            }
            this._varaibles.put(variable, value);
        }
    }

    public Object getVariable(String variable) {
        boolean isGlobal = variable.startsWith("$$");
        if (GLOBAL != this && isGlobal) {
            return GLOBAL.getVariable(variable);
        }
        Object value = this._varaibles.get(variable);
        return value;
    }

    public boolean contains(String variable) {
        boolean isGlobal = variable.startsWith("$$");
        if (GLOBAL != this && isGlobal) {
            return GLOBAL.contains(variable);
        }
        return this._varaibles.containsKey(variable);
    }

    public void print() {
        Enumeration<String> e = this._varaibles.keys();
        while (e.hasMoreElements()) {
            String variable = e.nextElement();
            Object value = this._varaibles.get(variable);
            System.out.println(String.format("   %s - %s is %s", this.toString(), variable, value.toString()));
        }
    }
}

