/*
 * Decompiled with CFR 0.152.
 */
package com.integ.janoslib;

import com.integpg.janoslib.utils.StringUtils;
import java.util.StringTokenizer;

public class Version
implements Comparable<Version> {
    private String _versionString;
    private final int _major;
    private final int _minor;
    private final int _revision;
    private final float _build;

    public Version(int major, int minor) {
        this(major, minor, 0, 0.0f);
    }

    public Version(int major, int minor, int revision) {
        this(major, minor, revision, 0.0f);
    }

    public Version(int major, int minor, int revision, float build) {
        this._major = major;
        this._minor = minor;
        this._revision = revision;
        this._build = build;
        this._versionString = String.format("%d.%d.%d.%f", this._major, this._minor, this._revision, Float.valueOf(this._build));
    }

    public static Version parse(String versionString) throws Exception {
        try {
            if ('v' == versionString.charAt(0)) {
                versionString = versionString.substring(1);
            }
            String[] buildParts = StringUtils.split(versionString, "-");
            StringTokenizer tokenizer = new StringTokenizer(buildParts[0], ".", false);
            int major = Integer.valueOf(tokenizer.nextToken());
            int minor = Integer.valueOf(tokenizer.nextToken());
            int revision = 0;
            if (tokenizer.hasMoreTokens()) {
                revision = Integer.valueOf(tokenizer.nextToken());
            }
            float build = 0.0f;
            if (tokenizer.hasMoreTokens()) {
                build = Integer.valueOf(tokenizer.nextToken()).intValue();
            }
            if (1 < buildParts.length) {
                if (0 == buildParts[1].indexOf("a")) {
                    buildParts[1] = buildParts[1].substring(1);
                } else if (0 == buildParts[1].indexOf("b")) {
                    buildParts[1] = buildParts[1].substring(1);
                } else if (0 == buildParts[1].indexOf("rc")) {
                    buildParts[1] = buildParts[1].substring(2);
                }
                Float.valueOf(buildParts[1]);
            }
            Version version = new Version(major, minor, revision, build);
            version._versionString = versionString;
            return version;
        }
        catch (Exception ex) {
            throw new Exception("Error parsing " + versionString, ex);
        }
    }

    public String toString() {
        return this._versionString;
    }

    @Override
    public int compareTo(Version v) {
        if (this._major > v._major) {
            return 1;
        }
        if (this._major < v._major) {
            return -1;
        }
        if (this._minor > v._minor) {
            return 1;
        }
        if (this._minor < v._minor) {
            return -1;
        }
        if (this._revision > v._revision) {
            return 1;
        }
        if (this._revision < v._revision) {
            return -1;
        }
        if (this._build > v._build) {
            return 1;
        }
        if (this._build < v._build) {
            return -1;
        }
        return 0;
    }
}

