/*
 * Decompiled with CFR 0.152.
 */
package com.integ.tasker.tasks.actions.relayoutputs;

import com.integ.tasker.tasks.Task;
import com.integ.tasker.tasks.TaskRuntime;
import com.integ.tasker.tasks.actions.Action;
import com.integpg.system.JANOS;
import java.io.IOException;
import java.util.Json;

public class PulseRelayMethod
extends Action {
    public PulseRelayMethod(Task parentTask, Json json) {
        super(parentTask, json);
        Json deviceActionJson = new Json();
        deviceActionJson.put("type", (Object)"PulseRelay");
        String channel = this._paramsJson.getString("Channel");
        deviceActionJson.put("name", (Object)"jnior");
        deviceActionJson.put("type", (Object)"PulseRelay");
        deviceActionJson.put("channel", (Object)channel);
        this._parentTask.addDeviceActionJson(deviceActionJson);
    }

    @Override
    public void execute(TaskRuntime taskRuntime) throws Throwable {
        boolean _debug_ = taskRuntime.Scope.isDebug();
        try {
            String stateString;
            int channel = this.getIntParam("Channel", taskRuntime);
            if (_debug_) {
                System.out.println("channel Param: " + channel);
            }
            if (null == (stateString = this.getStringParam("State", taskRuntime))) {
                stateString = "HIGH";
            }
            if (_debug_) {
                System.out.println("state Param: " + stateString);
            }
            double duration = this.getDoubleParam("Duration", taskRuntime);
            if (_debug_) {
                System.out.println(String.format("duration: %.2f seconds", duration));
            }
            int durationMillis = (int)(duration * 1000.0);
            if ("HIGH".equalsIgnoreCase(stateString)) {
                JANOS.setOutputPulsed((int)(1 << channel - 1), (int)(1 << channel - 1), (int)durationMillis);
            } else {
                JANOS.setOutputPulsed((int)0, (int)(1 << channel - 1), (int)durationMillis);
            }
        }
        catch (IOException ex) {
            throw new IOException("Error pulsing channel").initCause(ex);
        }
    }
}

