/*
 * Decompiled with CFR 0.152.
 */
package com.integ.tasker.devices.projectors;

import com.integ.tasker.devices.DeviceProfile;
import com.integ.tasker.devices.projectors.BarcoSeries1;
import com.integ.tasker.devices.projectors.BarcoSeries2;
import com.integ.tasker.devices.projectors.NECSeries1Projector;
import java.util.Json;

public class ProjectorFactory {
    public static DeviceProfile getDevice(Json json) throws Throwable {
        String soundProcessorType;
        Json paramsJson = (Json)json.get("Params");
        switch (soundProcessorType = paramsJson.getString("ProjectorType")) {
            case "barco-series-1": {
                return new BarcoSeries1(json);
            }
            case "barco-series-2": {
                return new BarcoSeries2(json);
            }
            case "nec-series-1": {
                return new NECSeries1Projector(json);
            }
        }
        throw new Exception(String.format("Unknown Projector Type: %s in %s", soundProcessorType, json.toString()));
    }
}

