/*
 * Decompiled with CFR 0.152.
 */
package com.integ.tasker.tasks.actions.network;

import com.integ.tasker.tasks.Task;
import com.integ.tasker.tasks.actions.Action;
import com.integ.tasker.tasks.actions.network.DeviceSendMethod;
import com.integ.tasker.tasks.actions.network.EmailProfileSendMethod;
import com.integ.tasker.tasks.actions.network.EmailSendMethod;
import com.integ.tasker.tasks.actions.network.HTTPGetMethod;
import com.integ.tasker.tasks.actions.network.HTTPPostMethod;
import com.integ.tasker.tasks.actions.network.MQTTPublishMethod;
import com.integ.tasker.tasks.actions.network.OSCSendMethod;
import com.integ.tasker.tasks.actions.network.ProjectorSend;
import com.integ.tasker.tasks.actions.network.SNMPSetMethod;
import com.integ.tasker.tasks.actions.network.SNMPTrapMethod;
import com.integ.tasker.tasks.actions.network.SerialSendMethod;
import com.integ.tasker.tasks.actions.network.SoundProcessorSend;
import com.integ.tasker.tasks.actions.network.TcpCloseMethod;
import com.integpg.janoslib.logging.AppLog;
import java.util.Json;

public class NetworkFactory {
    public static Action getActionMethod(Task parentTask, Json json) throws Throwable {
        String methodString;
        switch (methodString = json.getString("Method")) {
            case "DeviceSend": 
            case "TcpSend": {
                return new DeviceSendMethod(parentTask, json);
            }
            case "DeviceRecv": 
            case "TcpRecv": {
                AppLog.warn("Action has been depricated in favor of checking the \"Wait for Response\" checkbox in the Device Send action");
            }
            case "TcpClose": {
                return new TcpCloseMethod(parentTask, json);
            }
            case "SerialSend": {
                return new SerialSendMethod(parentTask, json);
            }
            case "SoundProcessorSend": {
                return new SoundProcessorSend(parentTask, json);
            }
            case "OSCSend": {
                return new OSCSendMethod(parentTask, json);
            }
            case "ProjectorSend": {
                return new ProjectorSend(parentTask, json);
            }
            case "EmailSend": {
                return new EmailSendMethod(parentTask, json);
            }
            case "EmailProfileSend": {
                return new EmailProfileSendMethod(parentTask, json);
            }
            case "SNMPTrap": {
                return new SNMPTrapMethod(parentTask, json);
            }
            case "SNMPSet": {
                return new SNMPSetMethod(parentTask, json);
            }
            case "HTTPGet": {
                return new HTTPGetMethod(parentTask, json);
            }
            case "HTTPPost": {
                return new HTTPPostMethod(parentTask, json);
            }
            case "MQTTPublish": {
                return new MQTTPublishMethod(parentTask, json);
            }
        }
        throw new Exception(String.format("Unknown Network method: %s in %s", methodString, json.toString()));
    }
}

