/*
 * Decompiled with CFR 0.152.
 */
package com.integ.tasker.schedules.rules;

import com.integ.tasker.schedules.Schedule;
import com.integ.tasker.schedules.rules.DateRuleBase;
import com.integ.tasker.schedules.rules.DateRuleFactory;
import com.integ.tasker.schedules.rules.OneTimeDateRule;
import com.integ.tasker.schedules.rules.ScheduleRuleBase;
import com.integpg.janoslib.utils.DateUtils;
import java.text.SimpleDateFormat;
import java.util.Json;

public class ScheduleRule
extends ScheduleRuleBase {
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd");
    private final Schedule _schedule;
    private final int _startHour;
    private final int _startMinute;
    private long _dayStartOffset;
    private final int _endHour;
    private final int _endMinute;
    private long _dayEndOffset;
    private boolean _acrossMidnight;
    private final long _repeatIntervalMillis;
    private final DateRuleBase _dateRule;

    public ScheduleRule(Schedule schedule, Json ScheduleRuleJson) {
        this._schedule = schedule;
        Json timeOptionsJson = (Json)ScheduleRuleJson.get("TimeOptions");
        Json startJson = (Json)timeOptionsJson.get("Start");
        this._startHour = startJson.getInt("Hour");
        this._startMinute = startJson.getInt("Minute");
        double repeatInterval = timeOptionsJson.getDouble("RepeatInterval");
        if (0.0 < repeatInterval) {
            String repeatIntervalUnits;
            switch (repeatIntervalUnits = timeOptionsJson.getString("RepeatIntervalUnits")) {
                case "Seconds": {
                    this._repeatIntervalMillis = (long)(repeatInterval * 1000.0);
                    break;
                }
                case "Minutes": {
                    this._repeatIntervalMillis = (long)(repeatInterval * 60000.0);
                    break;
                }
                case "Hours": {
                    this._repeatIntervalMillis = (long)(repeatInterval * 3600000.0);
                    break;
                }
                default: {
                    this._repeatIntervalMillis = 86400000L;
                }
            }
            Json endJson = (Json)timeOptionsJson.get("End");
            this._endHour = endJson.getInt("Hour");
            this._endMinute = endJson.getInt("Minute");
        } else {
            this._endHour = this._startHour;
            this._endMinute = this._startMinute;
            this._repeatIntervalMillis = 86400000L;
        }
        this._dayStartOffset = (long)this._startHour * 3600000L;
        this._dayStartOffset += (long)this._startMinute * 60000L;
        this._dayEndOffset = (long)this._endHour * 3600000L;
        this._dayEndOffset += (long)this._endMinute * 60000L;
        if (this._dayEndOffset == this._dayStartOffset) {
            this._dayEndOffset += 86400000L;
        }
        if (this._dayEndOffset < this._dayStartOffset) {
            Schedule.LOG.info("Crosses midnight");
            this._acrossMidnight = true;
        }
        Json dateOptionsJson = (Json)ScheduleRuleJson.get("DateOptions");
        this._dateRule = DateRuleFactory.getRule(dateOptionsJson);
    }

    @Override
    public void updateNextExecutionTime() {
        long now;
        long start = now = System.currentTimeMillis();
        long startOfDay = DateUtils.getStartOfDay();
        this._nextExecutionTime = this.getNextExecutionTime(startOfDay);
        long elapsed = System.currentTimeMillis() - start;
    }

    private long getNextExecutionTime(long startOfDay) {
        long now = System.currentTimeMillis();
        long nextExecutionTime = this._dateRule.getNextValidDayStart(startOfDay);
        nextExecutionTime += this._dayStartOffset;
        if (this._acrossMidnight) {
            nextExecutionTime -= 86400000L;
        }
        long dayEndTime = startOfDay + this._dayEndOffset;
        if (0L < this._repeatIntervalMillis && !(this._dateRule instanceof OneTimeDateRule)) {
            long savedNextExecutionTime = nextExecutionTime;
            while (now > nextExecutionTime) {
                if (dayEndTime >= savedNextExecutionTime && dayEndTime < (nextExecutionTime += this._repeatIntervalMillis)) {
                    nextExecutionTime = this._acrossMidnight ? startOfDay + this._dayStartOffset : this.getNextExecutionTime(startOfDay + 86400000L);
                }
                savedNextExecutionTime = nextExecutionTime;
            }
        }
        return nextExecutionTime;
    }
}

